/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.forwarder.PageForwarder;
import edu.cornell.mannlib.vedit.forwarder.impl.UrlForwarder;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vedit.validator.impl.RequiredFieldValidator;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyGroupRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)PropertyGroupRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.USE_MISCELLANEOUS_ADMIN_PAGES.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        EditProcessObject epo = super.createEpo((HttpServletRequest)request);
        String action = null;
        if (epo.getAction() == null) {
            action = "insert";
            epo.setAction("insert");
        } else {
            action = epo.getAction();
        }
        PropertyGroupDao pgDao = ModelAccess.on(this.getServletContext()).getWebappDaoFactory().getPropertyGroupDao();
        epo.setDataAccessObject(pgDao);
        PropertyGroup propertyGroupForEditing = null;
        if (!epo.getUseRecycledBean()) {
            if (request.getParameter("uri") != null) {
                try {
                    propertyGroupForEditing = pgDao.getGroupByURI(request.getParameter("uri"));
                    action = "update";
                    epo.setAction("update");
                }
                catch (NullPointerException e) {
                    log.error((Object)"Need to implement 'record not found' error message.");
                }
                if (propertyGroupForEditing == null) {
                    String uriToFind = new String(request.getParameter("uri"));
                    propertyGroupForEditing = pgDao.getGroupByURI(uriToFind);
                }
            } else {
                propertyGroupForEditing = new PropertyGroup();
            }
            epo.setOriginalBean(propertyGroupForEditing);
        } else {
            propertyGroupForEditing = (PropertyGroup)epo.getNewBean();
        }
        ArrayList<RequiredFieldValidator> validatorList = new ArrayList<RequiredFieldValidator>();
        validatorList.add(new RequiredFieldValidator());
        epo.getValidatorMap().put("Name", validatorList);
        epo.setPostInsertPageForwarder(new PropertyGroupInsertPageForwarder());
        epo.setPostDeletePageForwarder(new UrlForwarder("listPropertyGroups"));
        try {
            Class[] args = new Class[]{String.class};
            epo.setGetMethod(pgDao.getClass().getDeclaredMethod("getGroupByURI", args));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)(this.getClass().getName() + " could not find the getGroupByURI method"));
        }
        FormObject foo = new FormObject();
        foo.setErrorMap(epo.getErrMsgMap());
        epo.setFormObject(foo);
        FormUtils.populateFormFromBean(propertyGroupForEditing, action, foo, epo.getBadValueMap());
        request.setAttribute("formJsp", "/templates/edit/specific/propertyGroup_retry.jsp");
        request.setAttribute("scripts", "/templates/edit/formBasic.js");
        request.setAttribute("title", "Property Group Editing Form");
        request.setAttribute("_action", action);
        request.setAttribute("unqualifiedClassName", "PropertyGroup");
        this.setRequestAttributes((HttpServletRequest)request, epo);
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)"PropertyGroupRetryController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    class PropertyGroupInsertPageForwarder
    implements PageForwarder {
        PropertyGroupInsertPageForwarder() {
        }

        @Override
        public void doForward(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) {
            String newPropertyGroupUrl = "listPropertyGroups";
            try {
                response.sendRedirect(newPropertyGroupUrl);
            }
            catch (IOException ioe) {
                log.error((Object)"PropertyGroupInsertPageForwarder could not send redirect.");
            }
        }
    }
}

