/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class RestrictionOperationController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)RestrictionOperationController.class.getName());

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        String defaultLandingPage = this.getDefaultLandingPage((HttpServletRequest)request);
        try {
            String referer;
            OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
            HashMap epoHash = null;
            EditProcessObject epo = null;
            try {
                epoHash = (HashMap)request.getSession().getAttribute("epoHash");
                epo = (EditProcessObject)epoHash.get(request.getParameter("_epoKey"));
            }
            catch (NullPointerException e) {
                response.sendRedirect(defaultLandingPage);
                return;
            }
            if (epo == null) {
                response.sendRedirect(defaultLandingPage);
                return;
            }
            if (request.getParameter("_cancel") == null) {
                this.processRestriction(request, epo, ontModel);
            }
            if ((referer = epo.getReferer()) == null) {
                response.sendRedirect(defaultLandingPage);
            } else {
                response.sendRedirect(referer);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            try {
                response.sendRedirect(defaultLandingPage);
                return;
            }
            catch (Exception f) {
                log.error((Object)f, (Throwable)f);
                throw new RuntimeException(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRestriction(VitroRequest request, EditProcessObject epo, OntModel ontModel) {
        ontModel.enterCriticalSection(false);
        try {
            ontModel.getBaseModel().notifyEvent((Object)new EditEvent(request.getUnfilteredWebappDaoFactory().getUserURI(), true));
            if ("delete".equals(request.getParameter("_action"))) {
                this.processDelete(request, ontModel);
            } else {
                this.processCreate(request, epo, ontModel);
            }
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new EditEvent(request.getUnfilteredWebappDaoFactory().getUserURI(), false));
            ontModel.leaveCriticalSection();
        }
    }

    private void processDelete(VitroRequest request, OntModel ontModel) {
        String restId = request.getParameter("restrictionId");
        if (restId != null) {
            OntClass restrictedClass = ontModel.getOntClass(request.getParameter("classUri"));
            OntClass rest = null;
            ExtendedIterator i = restrictedClass.listEquivalentClasses();
            while (i.hasNext()) {
                OntClass equivClass = (OntClass)i.next();
                if (!equivClass.isAnon() || !equivClass.getId().toString().equals(restId)) continue;
                rest = equivClass;
            }
            if (rest == null) {
                i = restrictedClass.listSuperClasses();
                while (i.hasNext()) {
                    OntClass superClass = (OntClass)i.next();
                    if (!superClass.isAnon() || !superClass.getId().toString().equals(restId)) continue;
                    rest = superClass;
                }
            }
            if (rest != null) {
                Model temp = ModelFactory.createDefaultModel();
                temp.add(rest.listProperties());
                ontModel.getBaseModel().remove(temp);
            }
        }
    }

    private void processCreate(VitroRequest request, EditProcessObject epo, OntModel origModel) {
        Model temp = ModelFactory.createDefaultModel();
        Model dynamicUnion = ModelFactory.createUnion((Model)temp, (Model)origModel);
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)dynamicUnion);
        OntProperty onProperty = ontModel.getOntProperty(request.getParameter("onProperty"));
        String conditionTypeStr = request.getParameter("conditionType");
        String restrictionTypeStr = (String)epo.getAttribute("restrictionType");
        AllValuesFromRestriction rest = null;
        OntClass ontClass = ontModel.getOntClass((String)epo.getAttribute("VClassURI"));
        String roleFillerURIStr = request.getParameter("ValueClass");
        Resource roleFiller = null;
        if (roleFillerURIStr != null) {
            roleFiller = ontModel.getResource(roleFillerURIStr);
        }
        int cardinality = -1;
        String cardinalityStr = request.getParameter("cardinality");
        if (cardinalityStr != null) {
            cardinality = Integer.decode(cardinalityStr);
        }
        if (restrictionTypeStr.equals("allValuesFrom")) {
            rest = ontModel.createAllValuesFromRestriction(null, (Property)onProperty, roleFiller);
        } else if (restrictionTypeStr.equals("someValuesFrom")) {
            rest = ontModel.createSomeValuesFromRestriction(null, (Property)onProperty, roleFiller);
        } else if (restrictionTypeStr.equals("hasValue")) {
            String valueURI = request.getParameter("ValueIndividual");
            if (valueURI != null) {
                Resource valueRes = ontModel.getResource(valueURI);
                if (valueRes != null) {
                    rest = ontModel.createHasValueRestriction(null, (Property)onProperty, (RDFNode)valueRes);
                }
            } else {
                String valueLexicalForm = request.getParameter("ValueLexicalForm");
                if (valueLexicalForm != null) {
                    String valueDatatype = request.getParameter("ValueDatatype");
                    Literal value = null;
                    if (valueDatatype != null && valueDatatype.length() > 0) {
                        RDFDatatype dtype = null;
                        try {
                            dtype = TypeMapper.getInstance().getSafeTypeByName(valueDatatype);
                        }
                        catch (Exception e) {
                            log.warn((Object)("Unable to get safe type " + valueDatatype + " using TypeMapper"));
                        }
                        value = dtype != null ? ontModel.createTypedLiteral(valueLexicalForm, dtype) : ontModel.createLiteral(valueLexicalForm);
                    } else {
                        value = ontModel.createLiteral(valueLexicalForm);
                    }
                    rest = ontModel.createHasValueRestriction(null, (Property)onProperty, (RDFNode)value);
                }
            }
        } else if (restrictionTypeStr.equals("minCardinality")) {
            rest = ontModel.createMinCardinalityRestriction(null, (Property)onProperty, cardinality);
        } else if (restrictionTypeStr.equals("maxCardinality")) {
            rest = ontModel.createMaxCardinalityRestriction(null, (Property)onProperty, cardinality);
        } else if (restrictionTypeStr.equals("cardinality")) {
            rest = ontModel.createCardinalityRestriction(null, (Property)onProperty, cardinality);
        }
        if (conditionTypeStr.equals("necessary")) {
            ontClass.addSuperClass((Resource)rest);
        } else if (conditionTypeStr.equals("necessaryAndSufficient")) {
            ontClass.addEquivalentClass((Resource)rest);
        }
        origModel.add(temp);
    }
}

