/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing;

import edu.cornell.mannlib.vedit.beans.ButtonForm;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.edit.listing.ListingControllerWebUtils;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ObjectPropertyStatementListingController
extends BaseEditController {
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vrequest = new VitroRequest(request);
        boolean assertedStatementsOnly = false;
        String assertParam = request.getParameter("assertedStmts");
        if (assertParam != null && assertParam.equalsIgnoreCase("true")) {
            assertedStatementsOnly = true;
        }
        boolean showVClasses = false;
        String displayParam = request.getParameter("showVClasses");
        if (displayParam != null && displayParam.equalsIgnoreCase("true")) {
            showVClasses = true;
        }
        int startAt = 1;
        String startAtParam = request.getParameter("startAt");
        if (startAtParam != null && startAtParam.trim().length() > 0) {
            try {
                startAt = Integer.parseInt(startAtParam);
                if (startAt <= 0) {
                    startAt = 1;
                }
            }
            catch (NumberFormatException ex) {
                throw new Error("Cannot interpret " + startAtParam + " as a number");
            }
        }
        int endAt = 50;
        String endAtParam = request.getParameter("endAt");
        if (endAtParam != null && endAtParam.trim().length() > 0) {
            try {
                endAt = Integer.parseInt(endAtParam);
                if (endAt <= 0) {
                    endAt = 1;
                }
                if (endAt < startAt) {
                    int temp = startAt;
                    startAt = endAt;
                    endAt = temp;
                }
            }
            catch (NumberFormatException ex) {
                throw new Error("Cannot interpret " + endAtParam + " as a number");
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        request.setAttribute("results", results);
        results.add("XX");
        results.add("subject");
        if (showVClasses) {
            results.add("type");
        }
        results.add("property");
        results.add("object");
        if (showVClasses) {
            results.add("type");
        }
        ObjectPropertyStatementDao opsDao = null;
        opsDao = assertedStatementsOnly ? vrequest.getUnfilteredAssertionsWebappDaoFactory().getObjectPropertyStatementDao() : vrequest.getUnfilteredWebappDaoFactory().getObjectPropertyStatementDao();
        ObjectPropertyDao opDao = vrequest.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        IndividualDao iDao = null;
        iDao = showVClasses ? vrequest.getUnfilteredAssertionsWebappDaoFactory().getIndividualDao() : vrequest.getUnfilteredWebappDaoFactory().getIndividualDao();
        String propURIStr = request.getParameter("propertyURI");
        ObjectProperty op = opDao.getObjectPropertyByURI(propURIStr);
        int count = 0;
        Iterator<ObjectPropertyStatement> i = opsDao.getObjectPropertyStatements(op, startAt, endAt).iterator();
        while (i.hasNext()) {
            ++count;
            ObjectPropertyStatement ops = i.next();
            Individual subj = iDao.getIndividualByURI(ops.getSubjectURI());
            Individual obj = iDao.getIndividualByURI(ops.getObjectURI());
            results.add("XX");
            results.add(ListingControllerWebUtils.formatIndividualLink(subj));
            if (showVClasses) {
                try {
                    results.add(ListingControllerWebUtils.formatVClassLinks(subj.getVClasses(true)));
                }
                catch (Exception e) {
                    results.add("?");
                }
            }
            results.add(op.getDomainPublic());
            results.add(ListingControllerWebUtils.formatIndividualLink(obj));
            if (!showVClasses) continue;
            try {
                results.add(ListingControllerWebUtils.formatVClassLinks(obj.getVClasses(true)));
            }
            catch (Exception e) {
                results.add("?");
            }
        }
        if (count == 0) {
            results.add("XX");
            results.add("No statements found for property \"" + op.getPickListName() + "\"");
            results.add("");
            results.add("");
            if (showVClasses) {
                results.add("");
                results.add("");
            }
        }
        if (showVClasses) {
            request.setAttribute("columncount", (Object)new Integer(6));
        } else {
            request.setAttribute("columncount", (Object)new Integer(4));
        }
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)"Object Property Statements");
        ArrayList<ButtonForm> buttons = new ArrayList<ButtonForm>();
        HashMap<String, String> newPropParams = new HashMap<String, String>();
        newPropParams.put("controller", "Property");
        ButtonForm newPropButton = new ButtonForm("editForm", "buttonForm", "Add new object property", newPropParams);
        buttons.add(newPropButton);
        HashMap<String, String> rootPropParams = new HashMap<String, String>();
        rootPropParams.put("iffRoot", "true");
        ButtonForm rootPropButton = new ButtonForm("showObjectPropertyHierarchy", "buttonForm", "root properties", rootPropParams);
        buttons.add(rootPropButton);
        request.setAttribute("topButtons", buttons);
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/fetch/horizontal.jsp");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
    }
}

