/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OntologiesListingController
extends BaseEditController {
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vrequest = new VitroRequest(request);
        String noResultsMsgStr = "No ontologies found";
        OntologyDao dao = vrequest.getUnfilteredWebappDaoFactory().getOntologyDao();
        List<Ontology> onts = dao.getAllOntologies();
        ArrayList<String> results = new ArrayList<String>();
        results.add("XX");
        results.add("Ontology");
        results.add("Namespace");
        results.add("Prefix");
        if (onts != null && onts.size() > 0) {
            for (Ontology ont : onts) {
                results.add("XX");
                if (ont.getName() != null) {
                    try {
                        String ontologyName = ont.getName() == null || ont.getName().length() == 0 ? ont.getURI() : ont.getName();
                        results.add("<a href=\"./ontologyEdit?uri=" + URLEncoder.encode(ont.getURI(), "UTF-8") + "\">" + ontologyName + "</a>");
                    }
                    catch (Exception e) {
                        results.add(ont.getName());
                    }
                } else {
                    results.add("");
                }
                results.add(ont.getURI() == null ? "" : ont.getURI());
                results.add(ont.getPrefix() == null ? "(not yet specified)" : ont.getPrefix());
            }
        } else {
            results.add("XX");
            results.add("<strong>" + noResultsMsgStr + "</strong>");
        }
        request.setAttribute("results", results);
        request.setAttribute("columncount", (Object)new Integer(4));
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)"Ontologies");
        request.setAttribute("horizontalJspAddButtonUrl", (Object)"editForm");
        request.setAttribute("horizontalJspAddButtonText", (Object)"Add new ontology");
        request.setAttribute("horizontalJspAddButtonControllerParam", (Object)"Ontology");
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/fetch/horizontal.jsp");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }
}

