/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.SimpleRequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.ifaces.RequiresActions;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;

public class PageController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(PageController.class);
    protected static final String DEFAULT_TITLE = "Page";
    protected static final String DEFAULT_BODY_TEMPLATE = "emptyPage.ftl";
    protected static final String DATA_GETTER_MAP = "pageTypeToDataGetterMap";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        try {
            return AuthorizationRequest.AUTHORIZED.and(this.getActionsForPage(vreq)).and(this.getActionsForDataGetters(vreq));
        }
        catch (Exception e) {
            log.warn((Object)e);
            return AuthorizationRequest.UNAUTHORIZED;
        }
    }

    private AuthorizationRequest getActionsForPage(VitroRequest vreq) throws Exception {
        List<String> simplePremUris = vreq.getWebappDaoFactory().getPageDao().getRequiredActions(this.getPageUri(vreq));
        AuthorizationRequest auth = AuthorizationRequest.AUTHORIZED;
        for (String uri : simplePremUris) {
            auth = auth.and(new SimpleRequestedAction(uri));
        }
        return auth;
    }

    private AuthorizationRequest getActionsForDataGetters(VitroRequest vreq) {
        try {
            List<DataGetter> dgList = DataGetterUtils.getDataGettersForPage(vreq, (Model)vreq.getDisplayModel(), this.getPageUri(vreq));
            AuthorizationRequest auth = AuthorizationRequest.AUTHORIZED;
            for (DataGetter dg : dgList) {
                if (!(dg instanceof RequiresActions)) continue;
                auth = auth.and(((RequiresActions)((Object)dg)).requiredActions(vreq));
            }
            return auth;
        }
        catch (Exception e) {
            log.debug((Object)e);
            return AuthorizationRequest.UNAUTHORIZED;
        }
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) throws Exception {
        HashMap<String, Object> mapForTemplate = new HashMap<String, Object>();
        String pageUri = this.getPageUri(vreq);
        if (StringUtils.isEmpty((CharSequence)pageUri)) {
            return this.doNoPageSpecified(vreq);
        }
        mapForTemplate.put("pageUri", pageUri);
        try {
            Map<String, Object> page = vreq.getWebappDaoFactory().getPageDao().getPage(pageUri);
            mapForTemplate.put("page", page);
            if (page.containsKey("title")) {
                mapForTemplate.put("title", page.get("title"));
            }
        }
        catch (Throwable th) {
            return this.doNotFound(vreq);
        }
        this.executeDataGetters(pageUri, vreq, mapForTemplate);
        mapForTemplate.putAll(this.getPageControllerValues(pageUri, vreq, this.getServletContext(), mapForTemplate));
        TemplateResponseValues rv = new TemplateResponseValues(this.getTemplate(mapForTemplate), mapForTemplate);
        return rv;
    }

    private void executeDataGetters(String pageUri, VitroRequest vreq, Map<String, Object> mapForTemplate) throws Exception {
        List<DataGetter> dgList = DataGetterUtils.getDataGettersForPage(vreq, (Model)vreq.getDisplayModel(), pageUri);
        for (DataGetter dg : dgList) {
            Map<String, Object> moreData = dg.getData(mapForTemplate);
            if (moreData == null) continue;
            mapForTemplate.putAll(moreData);
        }
    }

    private Map<String, Object> getPageControllerValues(String pageUri, VitroRequest vreq, ServletContext servletContext, Map<String, Object> mapForTemplate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map pageMap = (Map)mapForTemplate.get("page");
        if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, new AuthorizationRequest[]{SimplePermission.MANAGE_MENUS.ACTION})) {
            String editPageUrl = UrlBuilder.getIndividualProfileUrl(pageUri, vreq);
            editPageUrl = UrlBuilder.addParams(editPageUrl, "switchToDisplayModel", "1");
            pageMap.put("URLToEditPage", editPageUrl);
        }
        return map;
    }

    private String getTemplate(Map<String, Object> mapForTemplate) {
        Map page;
        if (mapForTemplate.containsKey("page") && (page = (Map)mapForTemplate.get("page")) != null && page.containsKey("bodyTemplate")) {
            return (String)page.get("bodyTemplate");
        }
        if (mapForTemplate.containsKey("bodyTemplate")) {
            return (String)mapForTemplate.get("bodyTemplate");
        }
        return DEFAULT_BODY_TEMPLATE;
    }

    private ResponseValues doError(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", I18n.text((HttpServletRequest)vreq, "page_not_created", new Object[0]));
        body.put("errorMessage", I18n.text((HttpServletRequest)vreq, "page_not_created_msg", new Object[0]));
        return new TemplateResponseValues(FreemarkerHttpServlet.Template.TITLED_ERROR_MESSAGE.toString(), body, 500);
    }

    private ResponseValues doNotFound(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", I18n.text((HttpServletRequest)vreq, "page_not_found", new Object[0]));
        body.put("errorMessage", I18n.text((HttpServletRequest)vreq, "page_not_found_msg", new Object[0]));
        return new TemplateResponseValues(FreemarkerHttpServlet.Template.TITLED_ERROR_MESSAGE.toString(), body, 404);
    }

    private ResponseValues doNoPageSpecified(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", I18n.text((HttpServletRequest)vreq, "page_uri_missing", new Object[0]));
        body.put("errorMessage", I18n.text((HttpServletRequest)vreq, "page_uri_missing_msg", new Object[0]));
        return new TemplateResponseValues(FreemarkerHttpServlet.Template.TITLED_ERROR_MESSAGE.toString(), body, 404);
    }

    private String getPageUri(VitroRequest vreq) throws Exception {
        String pageURI = (String)vreq.getAttribute("pageURI");
        return pageURI;
    }

    public static void putPageUri(HttpServletRequest req, String pageUri) {
        req.setAttribute("pageURI", (Object)pageUri);
    }
}

