/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleReasonerRecomputeController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(SimpleReasonerRecomputeController.class);
    private static final String RECOMPUTE_INFERENCES_FTL = "recomputeInferences.ftl";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.USE_MISCELLANEOUS_ADMIN_PAGES.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String messageStr = "";
        try {
            Object sr = this.getServletContext().getAttribute(SimpleReasoner.class.getName());
            if (!(sr instanceof SimpleReasoner)) {
                messageStr = "No SimpleReasoner has been set up.";
            } else {
                SimpleReasoner simpleReasoner = (SimpleReasoner)sr;
                if (simpleReasoner.isABoxReasoningAsynchronous()) {
                    messageStr = "Reasoning is currently in asynchronous mode so a recompute cannot be started. Please try again later.";
                } else if (simpleReasoner.isRecomputing()) {
                    messageStr = "The system is currently in the process of recomputing inferences.";
                } else {
                    String submit = vreq.getParameter("submit");
                    if (submit != null) {
                        VitroBackgroundThread thread = new VitroBackgroundThread(new Recomputer(simpleReasoner), "SimpleReasonerRecomputController.Recomputer");
                        thread.setWorkLevel(VitroBackgroundThread.WorkLevel.WORKING, new String[0]);
                        thread.start();
                        messageStr = "Recompute of inferences started. See log for further details.";
                    } else {
                        body.put("formAction", UrlBuilder.getUrl("/RecomputeInferences"));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error recomputing inferences with SimpleReasoner", (Throwable)e);
            body.put("errorMessage", "There was an error while recomputing inferences: " + e.getMessage());
            return new ExceptionResponseValues(RECOMPUTE_INFERENCES_FTL, body, e);
        }
        body.put("message", messageStr);
        return new TemplateResponseValues(RECOMPUTE_INFERENCES_FTL, body);
    }

    private class Recomputer
    implements Runnable {
        private SimpleReasoner simpleReasoner;

        public Recomputer(SimpleReasoner simpleReasoner) {
            this.simpleReasoner = simpleReasoner;
        }

        @Override
        public void run() {
            this.simpleReasoner.recompute();
        }
    }
}

