/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfiguration;
import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfigurationImpl;
import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateProcessingHelper {
    private static final Log log = LogFactory.getLog(TemplateProcessingHelper.class);
    private Configuration config = null;

    public TemplateProcessingHelper(HttpServletRequest request) {
        this.config = FreemarkerConfiguration.getConfig(request);
    }

    public StringWriter processTemplate(String templateName, Map<String, Object> map) throws TemplateProcessingException {
        Template template = this.getTemplate(templateName);
        StringWriter sw = new StringWriter();
        this.processTemplate(template, map, sw);
        return sw;
    }

    private void processTemplate(Template template, Map<String, Object> map, Writer writer) throws TemplateProcessingException {
        try {
            Environment env = template.createProcessingEnvironment(map, writer);
            String templateType = (String)map.get("templateType");
            if ("page".equals(templateType)) {
                env.include(this.getTemplate("pageSetup.ftl"));
            }
            FreemarkerConfigurationImpl.retrieveAndRunDataGetters(env, template.getName());
            env.process();
        }
        catch (TemplateException e) {
            throw new TemplateProcessingException("TemplateException creating processing environment", e);
        }
        catch (IOException e) {
            throw new TemplateProcessingException("IOException creating processing environment", e);
        }
    }

    private Template getTemplate(String templateName) throws TemplateProcessingException {
        Template template = null;
        try {
            template = this.config.getTemplate(templateName);
        }
        catch (IOException e) {
            String msg = e instanceof ParseException ? "Syntax error in template " + templateName : (e instanceof FileNotFoundException ? "Cannot find template " + templateName : "IOException getting template " + templateName);
            throw new TemplateProcessingException(msg, e);
        }
        return template;
    }

    public class TemplateProcessingException
    extends Exception {
        public TemplateProcessingException(String message) {
            super(message);
        }

        public TemplateProcessingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

