/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.grefine;

import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GrefineMqlreadServlet
extends VitroHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)GrefineMqlreadServlet.class.getName());

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
        resp.setContentType("application/json");
        VitroRequest vreq = new VitroRequest(req);
        try {
            if (vreq.getParameter("query") != null) {
                JSONObject qJson = this.getResult(vreq, req, resp);
                log.debug((Object)("result: " + qJson.toString()));
                String responseStr = vreq.getParameter("callback") == null ? qJson.toString() : vreq.getParameter("callback") + "(" + qJson.toString() + ")";
                ServletOutputStream out = resp.getOutputStream();
                out.print(responseStr);
            }
        }
        catch (Exception ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
    }

    private JSONObject getResult(VitroRequest vreq, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        JSONObject resultAllJson = new JSONObject();
        try {
            ArrayList<String> subjectUriList = new ArrayList<String>();
            HashMap<String, JSONArray> propertyUriMap = new HashMap<String, JSONArray>();
            String query = vreq.getParameter("query");
            this.parseQuery(query, subjectUriList, propertyUriMap);
            JSONArray resultAllJsonArr = new JSONArray();
            DataPropertyStatementDao dpsDao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyStatementDao();
            for (String subjectUri : subjectUriList) {
                JSONObject subjectPropertyResultJson = new JSONObject();
                subjectPropertyResultJson.put("id", subjectUri);
                for (Map.Entry entry : propertyUriMap.entrySet()) {
                    int limit = 200;
                    String propertyUri = (String)entry.getKey();
                    JSONArray propertyUriOptions = (JSONArray)entry.getValue();
                    for (int i = 0; i < propertyUriOptions.length(); ++i) {
                        JSONObject propertyUriOption = (JSONObject)propertyUriOptions.get(i);
                        limit = (Integer)propertyUriOption.get("limit");
                    }
                    List<Literal> literals = dpsDao.getDataPropertyValuesForIndividualByProperty(subjectUri, propertyUri);
                    if (literals.size() <= 0) continue;
                    int counter = 0;
                    JSONArray valueJsonArr = new JSONArray();
                    for (Literal literal : literals) {
                        if (counter <= limit) {
                            String value = literal.getLexicalForm();
                            valueJsonArr.put(value);
                        }
                        ++counter;
                    }
                    subjectPropertyResultJson.put(propertyUri, valueJsonArr);
                }
                resultAllJsonArr.put(subjectPropertyResultJson);
            }
            resultAllJson.put("result", resultAllJsonArr);
        }
        catch (JSONException e) {
            log.error((Object)("GrefineMqlreadServlet getResult JSONException: " + e));
        }
        return resultAllJson;
    }

    private void parseQuery(String query, ArrayList<String> subjectUriList, Map<String, JSONArray> propertyUriMap) {
        try {
            JSONObject rawJson = new JSONObject(query);
            JSONArray qJsonArr = rawJson.getJSONArray("query");
            for (int i = 0; i < qJsonArr.length(); ++i) {
                Object obj = qJsonArr.get(i);
                if (!(obj instanceof JSONObject)) continue;
                JSONObject jsonObj = (JSONObject)obj;
                JSONArray jsonObjNames = jsonObj.names();
                for (int j = 0; j < jsonObjNames.length(); ++j) {
                    Object subjectUriObj;
                    Object propertyUriObj;
                    String objName = (String)jsonObjNames.get(j);
                    if (objName.contains("http://")) {
                        propertyUriObj = jsonObj.get(objName);
                        if (!(propertyUriObj instanceof JSONArray)) continue;
                        propertyUriMap.put(objName, (JSONArray)propertyUriObj);
                        continue;
                    }
                    if ("id".equals(objName)) {
                        propertyUriObj = jsonObj.get(objName);
                        continue;
                    }
                    if (!"id|=".equals(objName) || !((subjectUriObj = jsonObj.get(objName)) instanceof JSONArray)) continue;
                    JSONArray subjectUriUriArr = (JSONArray)subjectUriObj;
                    for (int k = 0; k < subjectUriUriArr.length(); ++k) {
                        Object subjectUriUriObj = subjectUriUriArr.get(k);
                        if (!(subjectUriUriObj instanceof String)) continue;
                        subjectUriList.add((String)subjectUriUriObj);
                    }
                }
            }
        }
        catch (JSONException e) {
            log.error((Object)("GrefineMqlreadServlet parseQuery JSONException: " + e));
        }
    }
}

