/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualTemplateLocator;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.ExecuteDataRetrieval;
import edu.cornell.mannlib.vitro.webapp.web.beanswrappers.ReadOnlyBeansWrapper;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.IndividualTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.IndividualTemplateModelBuilder;
import edu.ucsf.vitro.opensocial.OpenSocialManager;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.json.JSONException;

class IndividualResponseBuilder {
    private static final Log log = LogFactory.getLog(IndividualResponseBuilder.class);
    private static final Map<String, String> namespaces = new HashMap<String, String>(){
        {
            this.put("display", "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#");
            this.put("vitro", "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#");
            this.put("vitroPublic", "http://vitro.mannlib.cornell.edu/ns/vitro/public#");
        }
    };
    private final VitroRequest vreq;
    private final WebappDaoFactory wadf;
    private final IndividualDao iDao;
    private final ObjectPropertyDao opDao;
    private final ExecuteDataRetrieval eDataRetrieval;
    private final Individual individual;
    private static String LABEL_COUNT_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ( str(COUNT(?label)) AS ?labelCount ) WHERE { \n    ?subject rdfs:label ?label \n    FILTER isLiteral(?label) \n}";
    private static String DISTINCT_LANGUAGE_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ( str(COUNT(DISTINCT lang(?label))) AS ?languageCount ) WHERE { \n    ?subject rdfs:label ?label \n    FILTER isLiteral(?label) \n}";
    private static String PROFILE_TYPE_QUERY = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?profile WHERE { \n    ?subject display:hasDefaultProfilePageType ?profile \n}";

    public IndividualResponseBuilder(VitroRequest vreq, Individual individual) {
        this.vreq = vreq;
        this.wadf = vreq.getWebappDaoFactory();
        this.iDao = this.wadf.getIndividualDao();
        this.opDao = this.wadf.getObjectPropertyDao();
        this.individual = individual;
        this.eDataRetrieval = new ExecuteDataRetrieval(this.vreq, (Model)this.vreq.getDisplayModel(), this.individual);
    }

    ResponseValues assembleResponse() throws TemplateModelException {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", this.individual.getName());
        body.put("relatedSubject", this.getRelatedSubject());
        body.put("namespaces", namespaces);
        body.put("temporalVisualizationEnabled", this.getTemporalVisualizationFlag());
        body.put("profilePageTypesEnabled", this.getprofilePageTypesFlag());
        body.put("verbosePropertySwitch", this.getVerbosePropertyValues());
        this.addAltMetricOptions(body);
        try {
            this.eDataRetrieval.executeDataGetters(body);
        }
        catch (Exception ex) {
            log.error((Object)"Data retrieval for individual lead to error", (Throwable)ex);
        }
        String targetedView = "";
        targetedView = this.vreq.getParameter("destination");
        body.put("targetedView", targetedView);
        IndividualTemplateModel itm = this.getIndividualTemplateModel(this.individual);
        body.put("labelCount", IndividualResponseBuilder.getLabelCount(itm.getUri(), this.vreq));
        body.put("languageCount", IndividualResponseBuilder.getLanguagesRepresentedCount(itm.getUri(), this.vreq));
        body.put("localesCount", SelectedLocale.getSelectableLocales((HttpServletRequest)this.vreq).size());
        body.put("profileType", IndividualResponseBuilder.getProfileType(itm.getUri(), this.vreq));
        body.put("individual", this.wrap(itm, new ReadOnlyBeansWrapper()));
        body.put("headContent", this.getRdfLinkTag(itm));
        body.putAll(this.getSpecialEditingValues());
        try {
            OpenSocialManager openSocialManager = new OpenSocialManager(this.vreq, itm.isEditable() ? "individual-EDIT-MODE" : "individual", itm.isEditable());
            openSocialManager.setPubsubData("JSONPersonIds", OpenSocialManager.buildJSONPersonIds(this.individual, "1 person found"));
            body.put("openSocial", openSocialManager);
            if (openSocialManager.isVisible()) {
                body.put("bodyOnload", "my.init();");
            }
        }
        catch (JSONException e) {
            log.error((Object)"JSONException in doTemplate()", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"IOException in doTemplate()", (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"SQLException in doTemplate()", (Throwable)e);
        }
        String template = new IndividualTemplateLocator(this.vreq, this.individual).findTemplate();
        return new TemplateResponseValues(template, body);
    }

    private Map<String, Object> getRelatedSubject() {
        Individual relatedSubjectInd;
        HashMap<String, String> map = null;
        String relatedSubjectUri = this.vreq.getParameter("relatedSubjectUri");
        if (relatedSubjectUri != null && (relatedSubjectInd = this.iDao.getIndividualByURI(relatedSubjectUri)) != null) {
            ObjectProperty relatingPredicateProp;
            map = new HashMap<String, String>();
            map.put("name", relatedSubjectInd.getName());
            map.put("url", UrlBuilder.getIndividualProfileUrl(relatedSubjectInd, this.vreq));
            String relatingPredicateUri = this.vreq.getParameter("relatingPredicateUri");
            if (relatingPredicateUri != null && (relatingPredicateProp = this.opDao.getObjectPropertyByURI(relatingPredicateUri)) != null) {
                map.put("relatingPredicateDomainPublic", relatingPredicateProp.getDomainPublic());
            }
        }
        return map;
    }

    private void addAltMetricOptions(Map<String, Object> body) {
        ConfigurationProperties properties = ConfigurationProperties.getBean((ServletRequest)this.vreq);
        if (properties != null) {
            String enabled = properties.getProperty("resource.altmetric", "enabled");
            String displayTo = properties.getProperty("resource.altmetric.displayto", "right");
            String badgeType = properties.getProperty("resource.altmetric.badge-type", "donut");
            String badgeHideEmpty = properties.getProperty("resource.altmetric.hide-no-mentions", "true");
            String badgePopover = properties.getProperty("resource.altmetric.badge-popover", "right");
            String badgeDetails = properties.getProperty("resource.altmetric.badge-details");
            if (!"disabled".equalsIgnoreCase(enabled)) {
                body.put("altmetricEnabled", true);
                body.put("altmetricDisplayTo", displayTo);
                body.put("altmetricBadgeType", badgeType);
                if ("true".equalsIgnoreCase(badgeHideEmpty)) {
                    body.put("altmetricHideEmpty", true);
                }
                body.put("altmetricPopover", badgePopover);
                body.put("altmetricDetails", badgeDetails);
            }
        }
    }

    private boolean getTemporalVisualizationFlag() {
        String property = ConfigurationProperties.getBean((ServletRequest)this.vreq).getProperty("visualization.temporal");
        return "enabled".equals(property);
    }

    private boolean getprofilePageTypesFlag() {
        String property = ConfigurationProperties.getBean((ServletRequest)this.vreq).getProperty("multiViews.profilePageTypes");
        return "enabled".equals(property);
    }

    private Map<String, Object> getVerbosePropertyValues() {
        HashMap<String, Object> map = null;
        if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{SimplePermission.SEE_VERBOSE_PROPERTY_INFORMATION.ACTION})) {
            Boolean verboseValue;
            String verbose = this.vreq.getParameter("verbose");
            if (verbose != null) {
                verboseValue = "true".equals(verbose);
            } else {
                Boolean verbosePropertyDisplayValueInSession = (Boolean)this.vreq.getSession().getAttribute("verbosePropertyDisplay");
                verboseValue = Boolean.TRUE.equals(verbosePropertyDisplayValueInSession);
            }
            this.vreq.getSession().setAttribute("verbosePropertyDisplay", (Object)verboseValue);
            map = new HashMap<String, Object>();
            map.put("currentValue", verboseValue);
            String url = this.vreq.getRequestURI() + "?verbose=" + (verboseValue == false);
            String queryString = this.vreq.getQueryString();
            if (queryString != null) {
                String[] params;
                for (String param : params = queryString.split("&")) {
                    if (param.startsWith("verbose=")) continue;
                    url = url + "&" + param;
                }
            }
            map.put("url", url);
        } else {
            this.vreq.getSession().setAttribute("verbosePropertyDisplay", (Object)false);
        }
        return map;
    }

    private IndividualTemplateModel getIndividualTemplateModel(Individual individual) {
        return IndividualTemplateModelBuilder.build(individual, this.vreq);
    }

    private TemplateModel wrap(Object obj, BeansWrapper wrapper) throws TemplateModelException {
        return wrapper.wrap(obj);
    }

    private String getRdfLinkTag(IndividualTemplateModel itm) {
        String linkTag = null;
        String linkedDataUrl = itm.getRdfUrl();
        if (linkedDataUrl != null) {
            linkTag = "<link rel=\"alternate\" type=\"application/rdf+xml\" href=\"" + linkedDataUrl + "\" /> ";
        }
        return linkTag;
    }

    private Map<String, Object> getSpecialEditingValues() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.vreq.getAttribute("specialWriteModel") != null) {
            map.put("reorderUrl", UrlBuilder.getUrl("/menuManagementEdit?cmd=Reorder&switchToDisplayModel=true"));
        }
        return map;
    }

    private static Integer getLabelCount(String subjectUri, VitroRequest vreq) {
        String queryStr = QueryUtils.subUriForQueryVar(LABEL_COUNT_QUERY, "subject", subjectUri);
        log.debug((Object)("queryStr = " + queryStr));
        int theCount = 0;
        try {
            QuerySolution soln;
            RDFNode labelCount;
            ResultSet results = QueryUtils.getLanguageNeutralQueryResults(queryStr, vreq);
            if (results.hasNext() && (labelCount = (soln = results.nextSolution()).get("labelCount")) != null && labelCount.isLiteral()) {
                theCount = labelCount.asLiteral().getInt();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return theCount;
    }

    private static Integer getLanguagesRepresentedCount(String subjectUri, VitroRequest vreq) {
        String queryStr = QueryUtils.subUriForQueryVar(DISTINCT_LANGUAGE_QUERY, "subject", subjectUri);
        log.debug((Object)("queryStr = " + queryStr));
        int theCount = 0;
        try {
            QuerySolution soln;
            RDFNode languageCount;
            ResultSet results = QueryUtils.getLanguageNeutralQueryResults(queryStr, vreq);
            if (results.hasNext() && (languageCount = (soln = results.nextSolution()).get("languageCount")) != null && languageCount.isLiteral()) {
                theCount = languageCount.asLiteral().getInt();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return theCount;
    }

    private static String getProfileType(String subjectUri, VitroRequest vreq) {
        String queryStr = QueryUtils.subUriForQueryVar(PROFILE_TYPE_QUERY, "subject", subjectUri);
        log.debug((Object)("queryStr = " + queryStr));
        String profileType = "none";
        try {
            QuerySolution soln;
            String profileStr;
            ResultSet results = QueryUtils.getQueryResults(queryStr, vreq);
            if (results.hasNext() && (profileStr = (soln = results.nextSolution()).get("profile").toString()).length() > 0) {
                profileType = profileStr.substring(profileStr.indexOf("#") + 1, profileStr.length());
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return profileType;
    }
}

