/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individuallist;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.Controllers;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.IndividualListController;
import edu.cornell.mannlib.vitro.webapp.controller.individuallist.IndividualJsonWrapper;
import edu.cornell.mannlib.vitro.webapp.controller.individuallist.IndividualListResults;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IndividualListResultsUtils {
    private static final Log log = LogFactory.getLog(IndividualListResultsUtils.class);

    public static JSONObject wrapIndividualListResultsInJson(IndividualListResults results, VitroRequest vreq, boolean multipleVclasses) {
        JSONObject rObj = new JSONObject();
        if (log.isDebugEnabled()) {
            IndividualListResultsUtils.dumpParametersFromRequest(vreq);
        }
        try {
            List<VClass> vclasses = IndividualListResultsUtils.buildListOfRequestedVClasses(vreq);
            VClass vclass = null;
            vclass = !multipleVclasses ? vclasses.get(0) : vclasses.get(vclasses.size() - 1);
            rObj.put("vclass", IndividualListResultsUtils.packageVClassAsJson(vclass));
            rObj.put("totalCount", results.getTotalCount());
            rObj.put("alpha", results.getAlpha());
            rObj.put("individuals", IndividualListResultsUtils.packageIndividualsAsJson(vreq, results.getEntities()));
            rObj.put("pages", IndividualListResultsUtils.packagePageRecordsAsJson(results.getPages()));
            rObj.put("letters", IndividualListResultsUtils.packageLettersAsJson());
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in processing JSON object", (Throwable)ex);
        }
        return rObj;
    }

    private static List<VClass> buildListOfRequestedVClasses(VitroRequest vreq) throws Exception {
        Object[] vitroClassIdStr = vreq.getParameterValues("vclassId");
        if (ArrayUtils.isEmpty((Object[])vitroClassIdStr)) {
            log.error((Object)"parameter vclassId URI parameter expected ");
            throw new Exception("parameter vclassId URI parameter expected ");
        }
        ArrayList<VClass> list = new ArrayList<VClass>();
        for (Object vclassId : vitroClassIdStr) {
            VClass vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI((String)vclassId);
            if (vclass == null) {
                log.error((Object)"Couldn't retrieve vclass ");
                throw new Exception("Class " + (String)vclassId + " not found");
            }
            list.add(vclass);
        }
        return list;
    }

    private static JSONObject packageVClassAsJson(VClass vclass) throws JSONException {
        JSONObject jvclass = new JSONObject();
        jvclass.put("URI", vclass.getURI());
        jvclass.put("name", vclass.getName());
        return jvclass;
    }

    private static JSONArray packageLettersAsJson() throws JSONException, UnsupportedEncodingException {
        List<String> letters = Controllers.getLetters();
        JSONArray jletters = new JSONArray();
        for (String s : letters) {
            JSONObject jo = new JSONObject();
            jo.put("text", s);
            jo.put("param", "alpha=" + URLEncoder.encode(s, "UTF-8"));
            jletters.put(jo);
        }
        return jletters;
    }

    private static JSONArray packagePageRecordsAsJson(List<IndividualListController.PageRecord> pages) throws JSONException {
        JSONArray wpages = new JSONArray();
        for (IndividualListController.PageRecord pr : pages) {
            JSONObject p = new JSONObject();
            p.put("text", pr.text);
            p.put("param", pr.param);
            p.put("index", pr.index);
            wpages.put(p);
        }
        return wpages;
    }

    private static JSONArray packageIndividualsAsJson(VitroRequest vreq, List<Individual> inds) throws JSONException {
        log.debug((Object)("Number of individuals returned from request: " + inds.size()));
        JSONArray jInds = new JSONArray();
        for (Individual ind : inds) {
            jInds.put(IndividualJsonWrapper.packageIndividualAsJson(vreq, ind));
        }
        return jInds;
    }

    private static void dumpParametersFromRequest(VitroRequest vreq) {
        Map<String, String[]> pMap = vreq.getParameterMap();
        for (String name : pMap.keySet()) {
            for (String value : pMap.get(name)) {
                log.debug((Object)("value for " + name + ": '" + value + "'"));
            }
        }
    }
}

