/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.jena;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaModelUtils;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaOutputUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.JenaException;

public class JenaExportController
extends BaseEditController {
    private static final AuthorizationRequest REQUIRED_ACTIONS = SimplePermission.USE_ADVANCED_DATA_TOOLS_PAGES.ACTION.or(SimplePermission.EDIT_ONTOLOGY.ACTION);
    private static final Log log = LogFactory.getLog(JenaExportController.class);
    static final String FULL_GRAPH = "?g";
    static Map<String, String> formatToExtension = new HashMap<String, String>();
    static Map<String, String> formatToMimetype;
    private static final String ABOX_FULL_CONSTRUCT = "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH ?g { ?s ?p ?o } FILTER (!regex(str(?g), \"tbox\")) FILTER (?g != <http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata>) }";
    private static final String ABOX_ASSERTED_CONSTRUCT = "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH ?g { ?s ?p ?o } FILTER (!regex(str(?g), \"tbox\")) FILTER (?g != <http://vitro.mannlib.cornell.edu/default/vitro-kb-inf>) FILTER (?g != <http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata>) }";
    private static final String FULL_FULL_CONSTRUCT = "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }";
    private static final String FULL_ASSERTED_CONSTRUCT = "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH ?g { ?s ?p ?o } FILTER (?g != <http://vitro.mannlib.cornell.edu/default/vitro-kb-inf>) FILTER (?g != <http://vitro.mannlib.cornell.edu/default/inferred-tbox>) }";

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, REQUIRED_ACTIONS)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        if (vreq.getRequestURL().indexOf("/download/") > -1) {
            this.outputRDF(vreq, response);
            return;
        }
        String formatParam = vreq.getParameter("format");
        if (formatParam != null) {
            this.redirectToDownload(vreq, response);
        } else {
            this.prepareExportSelectionPage(vreq, response);
        }
    }

    private void redirectToDownload(VitroRequest vreq, HttpServletResponse response) {
        String extension;
        String formatStr = vreq.getParameter("format");
        String subgraphParam = vreq.getParameter("subgraph");
        String filename = null;
        filename = "abox".equals(subgraphParam) ? "ABox" : ("tbox".equals(subgraphParam) ? "TBox" : "export");
        String string = extension = formatStr != null && formatStr.startsWith("RDF/XML") && "tbox".equals(subgraphParam) ? ".owl" : formatToExtension.get(formatStr);
        if (extension == null) {
            throw new RuntimeException("Unsupported RDF export format " + formatStr);
        }
        String[] uriParts = vreq.getRequestURI().split("/");
        String base = uriParts[uriParts.length - 1];
        try {
            response.sendRedirect("./" + base + "/download/" + filename + extension + "?" + vreq.getQueryString());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputRDF(VitroRequest vreq, HttpServletResponse response) {
        Dataset dataset = vreq.getDataset();
        JenaModelUtils xutil = new JenaModelUtils();
        String formatParam = vreq.getParameter("format");
        String subgraphParam = vreq.getParameter("subgraph");
        String assertedOrInferredParam = vreq.getParameter("assertedOrInferred");
        String ontologyURI = vreq.getParameter("ontologyURI");
        Model model = null;
        OntModel ontModel = ModelFactory.createOntologyModel();
        if (!(subgraphParam.equalsIgnoreCase("tbox") || subgraphParam.equalsIgnoreCase("abox") || subgraphParam.equalsIgnoreCase("full"))) {
            ontologyURI = subgraphParam;
            subgraphParam = "tbox";
            char[] uri = ontologyURI.toCharArray();
            ontologyURI = "";
            for (int i = 0; i < uri.length - 1; ++i) {
                ontologyURI = ontologyURI + uri[i];
            }
        }
        if ("abox".equals(subgraphParam)) {
            model = ModelFactory.createDefaultModel();
            if ("inferred".equals(assertedOrInferredParam)) {
                model = ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf");
            } else if ("full".equals(assertedOrInferredParam)) {
                this.outputSparqlConstruct(ABOX_FULL_CONSTRUCT, formatParam, response);
            } else if ("asserted".equals(assertedOrInferredParam)) {
                this.outputSparqlConstruct(ABOX_ASSERTED_CONSTRUCT, formatParam, response);
            }
        } else if ("tbox".equals(subgraphParam)) {
            if ("inferred".equals(assertedOrInferredParam)) {
                OntModel tempModel = xutil.extractTBox((Model)ModelAccess.on(this.getServletContext()).getOntModel("vitro:tboxOntModel"), ontologyURI);
                OntModel inferenceModel = ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/inferred-tbox");
                inferenceModel.enterCriticalSection(true);
                try {
                    model = tempModel.intersection((Model)inferenceModel);
                }
                finally {
                    inferenceModel.leaveCriticalSection();
                }
            } else {
                model = "full".equals(assertedOrInferredParam) ? xutil.extractTBox((Model)ModelAccess.on(this.getServletContext()).getOntModel("vitro:tboxOntModel"), ontologyURI) : xutil.extractTBox((Model)ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox"), ontologyURI);
            }
        } else if ("full".equals(subgraphParam)) {
            if ("inferred".equals(assertedOrInferredParam)) {
                ontModel = xutil.extractTBox(dataset, ontologyURI, "http://vitro.mannlib.cornell.edu/default/vitro-kb-inf");
                ontModel.addSubModel((Model)ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf"));
                ontModel.addSubModel((Model)ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/inferred-tbox"));
            } else if ("full".equals(assertedOrInferredParam)) {
                this.outputSparqlConstruct(FULL_FULL_CONSTRUCT, formatParam, response);
            } else {
                this.outputSparqlConstruct(FULL_ASSERTED_CONSTRUCT, formatParam, response);
            }
        }
        JenaOutputUtils.setNameSpacePrefixes(model, vreq.getWebappDaoFactory());
        this.setHeaders(response, formatParam);
        try {
            ServletOutputStream outStream = response.getOutputStream();
            if (formatParam.startsWith("RDF/XML")) {
                outStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
            }
            try {
                if (!"full".equals(subgraphParam)) {
                    model.write((OutputStream)outStream, "N3".equals(formatParam) ? "TTL" : formatParam);
                } else {
                    ontModel.writeAll((OutputStream)outStream, "N3".equals(formatParam) ? "TTL" : formatParam, null);
                }
            }
            catch (JenaException je) {
                response.setContentType("text/plain");
                response.setHeader("content-disposition", "attachment; filename=export.txt");
                if (!"full".equals(subgraphParam)) {
                    model.write((OutputStream)outStream, "N-TRIPLE", null);
                } else {
                    ontModel.writeAll((OutputStream)outStream, "N-TRIPLE", null);
                }
                log.info((Object)"exported model in N-TRIPLE format instead of N3 because there was a problem exporting in N3 format");
            }
            outStream.flush();
            outStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void setHeaders(HttpServletResponse response, String formatParam) {
        String mime;
        if (formatParam == null) {
            formatParam = "RDF/XML-ABBREV";
        }
        if ((mime = formatToMimetype.get(formatParam)) == null) {
            throw new RuntimeException("Unsupported RDF format " + formatParam);
        }
        response.setContentType(mime);
        if (mime.equals("application/rdf+xml")) {
            response.setHeader("content-disposition", "attachment; filename=export.rdf");
        } else if (mime.equals("text/n3")) {
            response.setHeader("content-disposition", "attachment; filename=export.n3");
        } else if (mime.equals("text/plain")) {
            response.setHeader("content-disposition", "attachment; filename=export.txt");
        } else if (mime.equals("application/x-turtle")) {
            response.setHeader("content-disposition", "attachment; filename=export.ttl");
        }
    }

    private void outputSparqlConstruct(String queryStr, String formatParam, HttpServletResponse response) {
        try (RDFService rdfService = ModelAccess.on(this.getServletContext()).getRDFService();){
            this.setHeaders(response, formatParam);
            ServletOutputStream out = response.getOutputStream();
            if (formatParam.startsWith("RDF/XML")) {
                out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
            }
            InputStream in = rdfService.sparqlConstructQuery(queryStr, RDFServiceUtils.getSerializationFormatFromJenaString(formatParam));
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
            out.close();
        }
    }

    private void prepareExportSelectionPage(VitroRequest vreq, HttpServletResponse response) {
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)vreq, response, "/jenaIngest/exportSelection.jsp");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        formatToExtension.put("RDF/XML", ".rdf");
        formatToExtension.put("RDF/XML-ABBREV", ".rdf");
        formatToExtension.put("N3", ".n3");
        formatToExtension.put("N-TRIPLE", ".nt");
        formatToExtension.put("TURTLE", ".ttl");
        formatToMimetype = new HashMap<String, String>();
        formatToMimetype.put("RDF/XML", "application/rdf+xml");
        formatToMimetype.put("RDF/XML-ABBREV", "application/rdf+xml");
        formatToMimetype.put("N3", "text/n3");
        formatToMimetype.put("N-TRIPLE", "text/plain");
        formatToMimetype.put("TURTLE", "application/x-turtle");
    }
}

