/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.jena;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.jena.JenaIngestController;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.rdf.model.StmtIterator;

public class JenaXMLFileUpload
extends JenaIngestController {
    Log log = LogFactory.getLog(JenaXMLFileUpload.class);
    private String baseDirectoryForFiles;
    private int maxFileSize = 524288000;
    private XsltExecutable xsltExec;
    private Processor processor;

    public void init() throws ServletException {
        super.init();
        File baseDir = new File(this.getServletContext().getRealPath("/xmlFileUpload"));
        if (baseDir.exists() && baseDir.isDirectory()) {
            System.out.println("JenaXMLFileUpload, found upload directory of " + baseDir.getAbsolutePath());
        } else {
            System.out.println("Attemping to setup JenaXMLFileUpload with temp directory of " + baseDir.getAbsolutePath());
            baseDir.mkdir();
            if (baseDir.exists() && baseDir.isDirectory()) {
                System.out.println("Created directory " + baseDir.getAbsolutePath());
            } else {
                System.out.println("Could not create directory " + baseDir.getAbsolutePath());
            }
        }
        this.baseDirectoryForFiles = baseDir.getAbsolutePath();
        File xslt = new File(this.getServletContext().getRealPath("/xslt/xml2rdf.xsl"));
        System.out.println("JenaXMLFileUpload, attempting to load xslt " + xslt.getAbsolutePath());
        this.processor = new Processor(false);
        XsltCompiler compiler = this.processor.newXsltCompiler();
        try {
            this.xsltExec = compiler.compile((Source)new StreamSource(xslt));
            System.out.println("JenaXMLFileUpload, loaded " + xslt.getAbsolutePath());
        }
        catch (SaxonApiException e) {
            System.out.println("could not compile xslt/xml2rdf.xsl");
            System.out.println(e.getMessage());
        }
    }

    @Override
    public long maximumMultipartFileSize() {
        return this.maxFileSize;
    }

    @Override
    public boolean stashFileSizeException() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        VitroRequest vreq = new VitroRequest(request);
        if (vreq.hasFileSizeException()) {
            throw new ServletException("Size limit exceeded: " + vreq.getFileSizeException().getLocalizedMessage());
        }
        if (!vreq.isMultipart()) {
            throw new ServletException("Must POST a multipart encoded request");
        }
        this.log.debug((Object)"multipart content detected");
        if (!this.isAuthorizedToDisplayPage(request, resp, SimplePermission.USE_ADVANCED_DATA_TOOLS_PAGES.ACTION)) {
            return;
        }
        ModelMaker modelMaker = JenaXMLFileUpload.getModelMaker((HttpServletRequest)vreq);
        String targetModel = request.getParameter("targetModel");
        if (targetModel == null) {
            throw new ServletException("targetModel not specified.");
        }
        Model m = modelMaker.getModel(targetModel);
        if (m == null) {
            throw new ServletException("targetModel '" + targetModel + "' was not found.");
        }
        request.setAttribute("targetModel", (Object)targetModel);
        List<File> filesToLoad = this.saveFiles(vreq.getFiles());
        List<File> rdfxmlToLoad = this.convertFiles(filesToLoad);
        List<Model> modelsToLoad = this.loadRdfXml(rdfxmlToLoad);
        try {
            m.enterCriticalSection(false);
            for (Model model : modelsToLoad) {
                m.add(model);
            }
        }
        finally {
            m.leaveCriticalSection();
        }
        long count = this.countOfStatements(modelsToLoad);
        request.setAttribute("statementCount", (Object)count);
        request.setAttribute("title", (Object)"Uploaded files and converted to RDF");
        request.setAttribute("fileItems", vreq.getFiles());
        request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + vreq.getAppBean().getThemeDir() + "css/edit.css\"/>"));
        try {
            JSPPageHandler.renderBasicPage(request, resp, "/jenaIngest/xmlFileUploadSuccess.jsp");
        }
        catch (Exception e) {
            System.out.println(this.getClass().getName() + " could not forward to view.");
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_ADVANCED_DATA_TOOLS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        request.setAttribute("title", (Object)"Upload file and convert to RDF");
        request.setAttribute("modelNames", (Object)JenaXMLFileUpload.getModelMaker((HttpServletRequest)vreq).listModels().toList());
        request.setAttribute("models", null);
        request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + vreq.getAppBean().getThemeDir() + "css/edit.css\"/>"));
        try {
            JSPPageHandler.renderBasicPage(request, response, "/jenaIngest/xmlFileUpload.jsp");
        }
        catch (Exception e) {
            System.out.println(this.getClass().getName() + " could not forward to view.");
            System.out.println(e.getMessage());
            System.out.println(e.getStackTrace());
        }
    }

    private List<Model> loadRdfXml(List<File> rdfxmlToLoad) throws ServletException {
        ArrayList<Model> models = new ArrayList<Model>(rdfxmlToLoad.size());
        for (File file : rdfxmlToLoad) {
            Model tempModel = ModelFactory.createDefaultModel();
            try {
                tempModel.read((InputStream)new FileInputStream(file), null);
                models.add(tempModel);
            }
            catch (FileNotFoundException e) {
                throw new ServletException("Could not find file " + file.getAbsolutePath() + " when loading RDF/XML.");
            }
        }
        return models;
    }

    private List<File> convertFiles(List<File> filesToLoad) throws ServletException {
        ArrayList<File> rdfxmlFiles = new ArrayList<File>(filesToLoad.size());
        for (File file : filesToLoad) {
            try {
                XsltTransformer t = this.xsltExec.load();
                Serializer out = new Serializer();
                out.setOutputProperty(Serializer.Property.METHOD, "xml");
                out.setOutputProperty(Serializer.Property.INDENT, "yes");
                File outFile = new File(file.getAbsolutePath() + ".rdfxml");
                rdfxmlFiles.add(outFile);
                out.setOutputFile(outFile);
                t.setSource((Source)new StreamSource(file));
                t.setDestination((Destination)out);
                t.transform();
            }
            catch (SaxonApiException e) {
                this.log.error((Object)("could not convert " + file.getAbsolutePath() + " to RDF/XML: " + e.getMessage()));
                throw new ServletException("could not convert " + file.getAbsolutePath() + " to RDF/XML: " + e.getMessage());
            }
        }
        return rdfxmlFiles;
    }

    private List<File> saveFiles(Map<String, List<FileItem>> fileStreams) throws ServletException {
        ArrayList<File> filesToLoad = new ArrayList<File>();
        for (String fileItemKey : fileStreams.keySet()) {
            for (FileItem fileItem : fileStreams.get(fileItemKey)) {
                String originalName = fileItem.getName();
                String name = originalName.replaceAll("[,+\\\\/$%^&*#@!<>'\"~;]", "_");
                name = name.replace("..", "_");
                name = name.trim().toLowerCase();
                String saveLocation = this.baseDirectoryForFiles + File.separator + name;
                String savedName = name;
                int next = 0;
                boolean foundUnusedName = false;
                while (!foundUnusedName) {
                    File test = new File(saveLocation);
                    if (test.exists()) {
                        savedName = name + '(' + ++next + ')';
                        saveLocation = this.baseDirectoryForFiles + File.separator + savedName;
                        continue;
                    }
                    foundUnusedName = true;
                }
                File uploadedFile = new File(saveLocation);
                try {
                    fileItem.write(uploadedFile);
                }
                catch (Exception ex) {
                    this.log.error((Object)("Unable to save POSTed file. " + ex.getMessage()));
                    throw new ServletException("Unable to save file to the disk. " + ex.getMessage());
                }
                if (fileItem.getSize() < 1L) {
                    throw new ServletException("No file was uploaded or file was empty.");
                }
                filesToLoad.add(uploadedFile);
            }
        }
        return filesToLoad;
    }

    private long countOfStatements(List<Model> models) {
        long count = 0L;
        for (Model m : models) {
            StmtIterator it = m.listStatements();
            while (it.hasNext()) {
                it.next();
                ++count;
            }
            it.close();
        }
        return count;
    }
}

