/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonArrayProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetEntitiesByVClassContinuation
extends JsonArrayProducer {
    private static final Log log = LogFactory.getLog(GetEntitiesByVClassContinuation.class);

    protected GetEntitiesByVClassContinuation(VitroRequest vreq) {
        super(vreq);
    }

    @Override
    protected JSONArray process() throws ServletException {
        int count;
        log.debug((Object)"in getEntitiesByVClassContinuation()");
        String resKey = this.vreq.getParameter("resultKey");
        if (resKey == null) {
            throw new ServletException("Could not get resultKey");
        }
        HttpSession session = this.vreq.getSession();
        if (session == null) {
            throw new ServletException("there is no session to get the pervious results from");
        }
        List entsInVClass = (List)session.getAttribute(resKey);
        if (entsInVClass == null) {
            throw new ServletException("Could not find List<Individual> for resultKey " + resKey);
        }
        List<Individual> entsToReturn = new ArrayList(256);
        boolean more = false;
        if (entsInVClass.size() > 256) {
            more = true;
            ListIterator entsFromVclass = entsInVClass.listIterator();
            for (count = 0; entsFromVclass.hasNext() && count <= 256; ++count) {
                entsToReturn.add((Individual)entsFromVclass.next());
                entsFromVclass.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getEntitiesByVClassContinuation(): Creating reply with continue token, sending in this reply: " + count + ", remaing to send: " + entsInVClass.size()));
            }
        } else {
            entsToReturn = entsInVClass;
            count = entsToReturn.size();
            session.removeAttribute(resKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getEntitiesByVClassContinuation(): sending " + count + " Ind without continue token"));
            }
        }
        JSONArray ja = this.individualsToJson(entsToReturn);
        if (more) {
            try {
                JSONObject obj = new JSONObject();
                obj.put("resultGroup", "true");
                obj.put("size", count);
                StringBuffer nextUrlStr = this.vreq.getRequestURL();
                nextUrlStr.append("?").append("getEntitiesByVClass").append("=1&").append("resultKey=").append(resKey);
                obj.put("nextUrl", nextUrlStr.toString());
                ja.put(obj);
            }
            catch (JSONException je) {
                throw new ServletException(je.getMessage());
            }
        }
        log.debug((Object)"done with getEntitiesByVClassContinuation()");
        return ja;
    }
}

