/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonObjectProducer;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonServlet;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;

public class GetSearchIndividualsByVClasses
extends JsonObjectProducer {
    private static final Log log = LogFactory.getLog(GetSearchIndividualsByVClasses.class);

    public GetSearchIndividualsByVClasses(VitroRequest vreq) {
        super(vreq);
    }

    @Override
    protected JSONObject process() throws Exception {
        log.debug((Object)"Executing retrieval of individuals by vclasses");
        VClass vclass = null;
        log.debug((Object)"Retrieving search individuals by vclasses");
        String[] vitroClassIdStr = this.vreq.getParameterValues("vclassId");
        if (vitroClassIdStr != null && vitroClassIdStr.length > 0) {
            for (String vclassId : vitroClassIdStr) {
                log.debug((Object)("Iterating throug vclasses, using VClass " + vclassId));
                vclass = this.vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(vclassId);
                if (vclass != null) continue;
                log.error((Object)"Couldn't retrieve vclass ");
                throw new Exception("Class " + vclassId + " not found");
            }
        } else {
            log.error((Object)"parameter vclassId URI parameter expected but not found");
            throw new Exception("parameter vclassId URI parameter expected ");
        }
        List<String> vclassIds = Arrays.asList(vitroClassIdStr);
        return JsonServlet.getSearchIndividualsByVClasses(vclassIds, (HttpServletRequest)this.vreq);
    }
}

