/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonProducer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;

public abstract class JsonArrayProducer
extends JsonProducer {
    private static final Log log = LogFactory.getLog(JsonArrayProducer.class);
    protected final VitroRequest vreq;
    protected final ServletContext ctx;

    protected JsonArrayProducer(VitroRequest vreq) {
        this.vreq = vreq;
        this.ctx = vreq.getSession().getServletContext();
    }

    protected abstract JSONArray process() throws Exception;

    public final void process(HttpServletResponse resp) throws IOException {
        JSONArray jsonArray = null;
        try {
            jsonArray = this.process();
        }
        catch (Exception e) {
            log.error((Object)("Failed to create JSON response" + e));
            resp.setStatus(500);
        }
        if (jsonArray == null) {
            jsonArray = new JSONArray();
        }
        log.debug((Object)("Response to JSON request: " + jsonArray.toString()));
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/json;charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(jsonArray.toString());
    }
}

