/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonProducer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonObjectProducer
extends JsonProducer {
    private static final Log log = LogFactory.getLog(JsonObjectProducer.class);
    protected final VitroRequest vreq;
    protected final ServletContext ctx;

    protected JsonObjectProducer(VitroRequest vreq) {
        this.vreq = vreq;
        this.ctx = vreq.getSession().getServletContext();
    }

    protected abstract JSONObject process() throws Exception;

    public final void process(HttpServletResponse resp) throws IOException {
        JSONObject jsonObject = null;
        String errorMessage = "";
        try {
            jsonObject = this.process();
        }
        catch (Exception e) {
            log.error((Object)"Failed to create JSON response", (Throwable)e);
            errorMessage = e.toString();
            resp.setStatus(500);
        }
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        log.debug((Object)("Response to JSON request: " + jsonObject.toString()));
        try {
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json;charset=UTF-8");
            PrintWriter writer = resp.getWriter();
            jsonObject.put("errorMessage", errorMessage);
            ((Writer)writer).write(jsonObject.toString());
        }
        catch (JSONException e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

