/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.UnionClass;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public class VClassJena
extends VClass {
    private static final Log log = LogFactory.getLog((String)VClassJena.class.getName());
    private OntClass cls = null;
    private WebappDaoFactoryJena webappDaoFactory = null;

    public VClassJena(OntClass cls, WebappDaoFactoryJena wadf) {
        this.cls = cls;
        if (cls.isAnon()) {
            this.setNamespace("http://vitro.mannlib.cornell.edu/ns/bnode#");
            this.setLocalName(cls.getId().toString());
        } else {
            this.URI = cls.getURI();
            this.namespace = cls.getNameSpace();
            this.localName = cls.getLocalName();
        }
        this.webappDaoFactory = wadf;
    }

    @Override
    public VClassJena copy() {
        VClassJena that = new VClassJena(this.cls, this.webappDaoFactory);
        this.copyFields(that);
        return that;
    }

    @Override
    public String getName() {
        if (this.myName != null) {
            return this.myName;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            VClassDao vClassDao = this.webappDaoFactory.getVClassDao();
            if (vClassDao instanceof VClassDaoJena) {
                this.myName = ((VClassDaoJena)vClassDao).getLabelForClass(this.cls, false, false);
            } else {
                log.error((Object)("WebappDaoFactory returned a type of " + vClassDao.getClass().getName() + ". Expected  VClassDaoJena"));
                this.myName = this.webappDaoFactory.getJenaBaseDao().getLabelOrId((OntResource)this.cls);
            }
            String string = this.myName;
            return string;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getLocalNameWithPrefix() {
        if (this.localNameWithPrefix != null) {
            return this.localNameWithPrefix;
        }
        this.localNameWithPrefix = this.webappDaoFactory.makeLocalNameWithPrefix(this);
        return this.localNameWithPrefix;
    }

    @Override
    public String getPickListName() {
        if (this.pickListName != null) {
            return this.pickListName;
        }
        this.pickListName = this.webappDaoFactory.makePickListName(this);
        return this.pickListName;
    }

    @Override
    public String getExample() {
        if (this.myExample != null) {
            return this.myExample;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setExample(this.webappDaoFactory.getJenaBaseDao().getPropertyStringValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().EXAMPLE_ANNOT));
            String string = this.myExample;
            return string;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getDescription() {
        if (this.myDescription != null) {
            return this.myDescription;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setDescription(this.webappDaoFactory.getJenaBaseDao().getPropertyStringValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().DESCRIPTION_ANNOT));
            String string = this.myDescription;
            return string;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getShortDef() {
        if (this.myShortDefinition != null) {
            return this.myShortDefinition;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setShortDef(this.webappDaoFactory.getJenaBaseDao().getPropertyStringValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().SHORTDEF));
            String string = this.myShortDefinition;
            return string;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public int getDisplayLimit() {
        if (this.displayLimit != null) {
            return this.displayLimit;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setDisplayLimit(this.webappDaoFactory.getJenaBaseDao().getPropertyNonNegativeIntValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().DISPLAY_LIMIT));
            int n = this.displayLimit;
            return n;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public int getDisplayRank() {
        if (this.displayRank != null) {
            return this.displayRank;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setDisplayRank(this.webappDaoFactory.getJenaBaseDao().getPropertyNonNegativeIntValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().DISPLAY_RANK_ANNOT));
            int n = this.displayRank;
            return n;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getGroupURI() {
        if (this.groupURI != null) {
            return this.groupURI;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            Resource groupRes = (Resource)this.cls.getPropertyValue((Property)this.webappDaoFactory.getJenaBaseDao().IN_CLASSGROUP);
            if (groupRes != null) {
                this.setGroupURI(groupRes.getURI());
            }
        }
        catch (Exception e) {
            log.error((Object)("error retrieving vitro:inClassGroup property value for " + this.cls.getURI()));
            log.trace((Object)e);
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
        return this.groupURI;
    }

    @Override
    public String getCustomEntryForm() {
        if (this.customEntryForm != null) {
            return this.customEntryForm;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setCustomEntryForm(this.webappDaoFactory.getJenaBaseDao().getPropertyStringValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().PROPERTY_CUSTOMENTRYFORMANNOT));
            String string = this.customEntryForm;
            return string;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getCustomDisplayView() {
        if (this.customDisplayView != null) {
            return this.customDisplayView;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setCustomDisplayView(this.webappDaoFactory.getJenaBaseDao().getPropertyStringValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().PROPERTY_CUSTOMDISPLAYVIEWANNOT));
            String string = this.customDisplayView;
            return string;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getCustomShortView() {
        if (this.customShortView != null) {
            return this.customShortView;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setCustomShortView(this.webappDaoFactory.getJenaBaseDao().getPropertyStringValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().PROPERTY_CUSTOMSHORTVIEWANNOT));
            String string = this.customShortView;
            return string;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public String getCustomSearchView() {
        if (this.customSearchView != null) {
            return this.customSearchView;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setCustomSearchView(this.webappDaoFactory.getJenaBaseDao().getPropertyStringValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().PROPERTY_CUSTOMSEARCHVIEWANNOT));
            String string = this.customSearchView;
            return string;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public Float getSearchBoost() {
        if (this.searchBoost != null) {
            return this.searchBoost;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            this.setSearchBoost(this.webappDaoFactory.getJenaBaseDao().getPropertyFloatValue((OntResource)this.cls, (Property)this.webappDaoFactory.getJenaBaseDao().SEARCH_BOOST_ANNOT));
            Float f = this.searchBoost;
            return f;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseResourceBean.RoleLevel getHiddenFromDisplayBelowRoleLevel() {
        if (this.hiddenFromDisplayBelowRoleLevel != null) {
            return this.hiddenFromDisplayBelowRoleLevel;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator it = this.cls.listProperties((Property)this.webappDaoFactory.getJenaBaseDao().HIDDEN_FROM_DISPLAY_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel hiddenRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || hiddenRoleLevel != null && roleFromModel.compareTo(hiddenRoleLevel) <= 0) continue;
                hiddenRoleLevel = roleFromModel;
            }
            this.setHiddenFromDisplayBelowRoleLevel(hiddenRoleLevel);
            BaseResourceBean.RoleLevel roleLevel = this.hiddenFromDisplayBelowRoleLevel;
            return roleLevel;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseResourceBean.RoleLevel getProhibitedFromUpdateBelowRoleLevel() {
        if (this.prohibitedFromUpdateBelowRoleLevel != null) {
            return this.prohibitedFromUpdateBelowRoleLevel;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator it = this.cls.listProperties((Property)this.webappDaoFactory.getJenaBaseDao().PROHIBITED_FROM_UPDATE_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel prohibitedRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || prohibitedRoleLevel != null && roleFromModel.compareTo(prohibitedRoleLevel) <= 0) continue;
                prohibitedRoleLevel = roleFromModel;
            }
            this.setProhibitedFromUpdateBelowRoleLevel(prohibitedRoleLevel);
            BaseResourceBean.RoleLevel roleLevel = this.prohibitedFromUpdateBelowRoleLevel;
            return roleLevel;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseResourceBean.RoleLevel getHiddenFromPublishBelowRoleLevel() {
        if (this.hiddenFromPublishBelowRoleLevel != null) {
            return this.hiddenFromPublishBelowRoleLevel;
        }
        this.cls.getOntModel().enterCriticalSection(true);
        try {
            StmtIterator it = this.cls.listProperties((Property)this.webappDaoFactory.getJenaBaseDao().HIDDEN_FROM_PUBLISH_BELOW_ROLE_LEVEL_ANNOT);
            BaseResourceBean.RoleLevel publishRoleLevel = null;
            while (it.hasNext()) {
                BaseResourceBean.RoleLevel roleFromModel;
                Resource res;
                RDFNode obj;
                Statement stmt = it.nextStatement();
                if (stmt == null || (obj = stmt.getObject()) == null || !obj.isURIResource() || (res = (Resource)obj.as(Resource.class)) == null || res.getURI() == null || (roleFromModel = BaseResourceBean.RoleLevel.getRoleByUri(res.getURI())) == null || publishRoleLevel != null && roleFromModel.compareTo(publishRoleLevel) <= 0) continue;
                publishRoleLevel = roleFromModel;
            }
            this.setHiddenFromPublishBelowRoleLevel(publishRoleLevel);
            BaseResourceBean.RoleLevel roleLevel = this.hiddenFromPublishBelowRoleLevel;
            return roleLevel;
        }
        finally {
            this.cls.getOntModel().leaveCriticalSection();
        }
    }

    @Override
    public boolean isUnion() {
        return this.cls.isUnionClass();
    }

    @Override
    public List<VClass> getUnionComponents() {
        ArrayList<VClass> unionComponents = new ArrayList<VClass>();
        if (this.isUnion()) {
            UnionClass union = (UnionClass)this.cls.as(UnionClass.class);
            ExtendedIterator opIt = union.listOperands();
            while (opIt.hasNext()) {
                OntClass component = (OntClass)opIt.next();
                if (component.isAnon()) continue;
                unionComponents.add(new VClassJena(component, this.webappDaoFactory));
            }
        }
        return unionComponents;
    }
}

