/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryConfig;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DataPropertyStatementDaoSDB;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapperFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.IndividualDaoSDB;
import edu.cornell.mannlib.vitro.webapp.dao.jena.ObjectPropertyStatementDaoSDB;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.StaticDatasetFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassDaoSDB;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.jena.query.Dataset;
import org.apache.jena.sdb.SDBFactory;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.sql.SDBConnection;

public class WebappDaoFactorySDB
extends WebappDaoFactoryJena {
    private SDBDatasetMode datasetMode = SDBDatasetMode.ASSERTIONS_AND_INFERENCES;

    public WebappDaoFactorySDB(RDFService rdfService, OntModelSelector ontModelSelector) {
        this(rdfService, ontModelSelector, new WebappDaoFactoryConfig());
    }

    public WebappDaoFactorySDB(RDFService rdfService, OntModelSelector ontModelSelector, WebappDaoFactoryConfig config) {
        this(rdfService, ontModelSelector, config, null);
    }

    public WebappDaoFactorySDB(RDFService rdfService, OntModelSelector ontModelSelector, WebappDaoFactoryConfig config, SDBDatasetMode datasetMode) {
        super(ontModelSelector, config);
        this.dwf = new StaticDatasetFactory(new RDFServiceDataset(rdfService));
        this.rdfService = rdfService;
        if (datasetMode != null) {
            this.datasetMode = datasetMode;
        }
    }

    public String toString() {
        return "WebappDaoFactorySDB[" + Integer.toString(this.hashCode(), 16) + ", " + (Object)((Object)this.datasetMode) + "]";
    }

    public WebappDaoFactorySDB(WebappDaoFactorySDB base, String userURI) {
        super(base.ontModelSelector);
        this.ontModelSelector = base.ontModelSelector;
        this.config = base.config;
        this.userURI = userURI;
        this.dwf = base.dwf;
        this.rdfService = base.rdfService;
    }

    @Override
    public IndividualDao getIndividualDao() {
        if (this.entityWebappDao != null) {
            return this.entityWebappDao;
        }
        this.entityWebappDao = new IndividualDaoSDB(this.dwf, this.datasetMode, this);
        return this.entityWebappDao;
    }

    @Override
    public DataPropertyStatementDao getDataPropertyStatementDao() {
        if (this.dataPropertyStatementDao != null) {
            return this.dataPropertyStatementDao;
        }
        this.dataPropertyStatementDao = new DataPropertyStatementDaoSDB(this.dwf, this.datasetMode, this);
        return this.dataPropertyStatementDao;
    }

    @Override
    public ObjectPropertyStatementDao getObjectPropertyStatementDao() {
        if (this.objectPropertyStatementDao != null) {
            return this.objectPropertyStatementDao;
        }
        this.objectPropertyStatementDao = new ObjectPropertyStatementDaoSDB(this.rdfService, this.dwf, this.datasetMode, this);
        return this.objectPropertyStatementDao;
    }

    @Override
    public VClassDao getVClassDao() {
        if (this.vClassDao != null) {
            return this.vClassDao;
        }
        this.vClassDao = new VClassDaoSDB(this.dwf, this.datasetMode, this, this.config.isUnderlyingStoreReasoned());
        return this.vClassDao;
    }

    @Override
    public WebappDaoFactory getUserAwareDaoFactory(String userURI) {
        return new WebappDaoFactorySDB(this, userURI);
    }

    public RDFService getRDFService() {
        return this.rdfService;
    }

    public static String getFilterBlock(String[] graphVars, SDBDatasetMode datasetMode) {
        StringBuffer filterBlock = new StringBuffer();
        block4: for (int i = 0; i < graphVars.length; ++i) {
            switch (datasetMode) {
                case ASSERTIONS_ONLY: {
                    filterBlock.append("FILTER (").append("(!bound(").append(graphVars[i]).append(")) || (").append(graphVars[i]).append(" != <").append("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf").append("> ").append("&& ").append(graphVars[i]).append(" != <").append("http://vitro.mannlib.cornell.edu/default/inferred-tbox").append(">").append(") ) \n");
                    continue block4;
                }
                case INFERENCES_ONLY: {
                    filterBlock.append("FILTER (").append("(!bound(").append(graphVars[i]).append(")) || (").append(graphVars[i]).append(" = <").append("http://vitro.mannlib.cornell.edu/default/vitro-kb-inf").append("> || ").append(graphVars[i]).append(" = <").append("http://vitro.mannlib.cornell.edu/default/inferred-tbox").append(">) )\n");
                    continue block4;
                }
            }
        }
        return filterBlock.toString();
    }

    @Override
    public void close() {
        super.close();
        if (this.rdfService != null) {
            this.rdfService.close();
        }
    }

    private class ReconnectingDatasetFactory
    implements DatasetWrapperFactory {
        private BasicDataSource _bds;
        private StoreDesc _storeDesc;

        public ReconnectingDatasetFactory(BasicDataSource bds, StoreDesc storeDesc) {
            this._bds = bds;
            this._storeDesc = storeDesc;
        }

        @Override
        public DatasetWrapper getDatasetWrapper() {
            try {
                Connection sqlConn = this._bds.getConnection();
                SDBConnection conn = new SDBConnection(sqlConn);
                Store store = SDBFactory.connectStore((SDBConnection)conn, (StoreDesc)this._storeDesc);
                Dataset dataset = SDBFactory.connectDataset((Store)store);
                return new DatasetWrapper(dataset, conn);
            }
            catch (SQLException sqe) {
                throw new RuntimeException("Unable to connect to database", sqe);
            }
        }
    }

    public static enum SDBDatasetMode {
        ASSERTIONS_ONLY,
        INFERENCES_ONLY,
        ASSERTIONS_AND_INFERENCES;

    }
}

