/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.RdfLiteralHash;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.freemarker.config.FreemarkerConfiguration;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import freemarker.template.Configuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;

public class EditConfigurationUtils {
    private static Log log = LogFactory.getLog(EditConfigurationUtils.class);
    protected static final String MULTI_VALUED_EDIT_SUBMISSION = "MultiValueEditSubmission";

    public static String getSubjectUri(VitroRequest vreq) {
        return vreq.getParameter("subjectUri");
    }

    public static String getPredicateUri(VitroRequest vreq) {
        return vreq.getParameter("predicateUri");
    }

    public static String getObjectUri(VitroRequest vreq) {
        return vreq.getParameter("objectUri");
    }

    public static String getDomainUri(VitroRequest vreq) {
        return vreq.getParameter("domainUri");
    }

    public static String getRangeUri(VitroRequest vreq) {
        return vreq.getParameter("rangeUri");
    }

    public static VClass getRangeVClass(VitroRequest vreq) {
        WebappDaoFactory ctxDaoFact = ModelAccess.on(vreq.getSession().getServletContext()).getWebappDaoFactory();
        return ctxDaoFact.getVClassDao().getVClassByURI(EditConfigurationUtils.getRangeUri(vreq));
    }

    public static Individual getSubjectIndividual(VitroRequest vreq) {
        Individual subject = null;
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        subject = EditConfigurationUtils.getIndividual(vreq, subjectUri);
        if (subject != null) {
            vreq.setAttribute("subject", subject);
        }
        return subject;
    }

    public static Individual getIndividual(VitroRequest vreq, String uri) {
        Individual individual = null;
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        if (uri != null) {
            individual = wdf.getIndividualDao().getIndividualByURI(uri);
        }
        return individual;
    }

    public static Individual getObjectIndividual(VitroRequest vreq) {
        String objectUri = EditConfigurationUtils.getObjectUri(vreq);
        Individual object = EditConfigurationUtils.getIndividual(vreq, objectUri);
        if (object != null) {
            vreq.setAttribute("subject", object);
        }
        return object;
    }

    public static ObjectProperty getObjectProperty(VitroRequest vreq) {
        return EditConfigurationUtils.getObjectPropertyForPredicate(vreq, EditConfigurationUtils.getPredicateUri(vreq));
    }

    public static DataProperty getDataProperty(VitroRequest vreq) {
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        return EditConfigurationUtils.getDataPropertyForPredicate(vreq, predicateUri);
    }

    public static ObjectProperty getObjectPropertyForPredicate(VitroRequest vreq, String predicateUri) {
        String domainUri = EditConfigurationUtils.getDomainUri(vreq);
        String rangeUri = EditConfigurationUtils.getRangeUri(vreq);
        return EditConfigurationUtils.getObjectPropertyForPredicate(vreq, predicateUri, domainUri, rangeUri);
    }

    public static ObjectProperty getObjectPropertyForPredicate(VitroRequest vreq, String predicateUri, String domainUri, String rangeUri) {
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        ObjectProperty objectProp = wdf.getObjectPropertyDao().getObjectPropertyByURIs(predicateUri, domainUri, rangeUri);
        return objectProp;
    }

    public static DataProperty getDataPropertyForPredicate(VitroRequest vreq, String predicateUri) {
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        WebappDaoFactory unfilteredWdf = vreq.getUnfilteredWebappDaoFactory();
        DataProperty dataProp = unfilteredWdf.getDataPropertyDao().getDataPropertyByURI(predicateUri);
        if (dataProp != null) {
            return dataProp;
        }
        return wdf.getDataPropertyDao().getDataPropertyByURI(predicateUri);
    }

    public static String getFormUrlWithoutContext(VitroRequest vreq) {
        return EditConfigurationUtils.getEditUrlWithoutContext(vreq) + "?" + vreq.getQueryString();
    }

    public static String getFormUrl(VitroRequest vreq) {
        return EditConfigurationUtils.getEditUrl(vreq) + "?" + vreq.getQueryString();
    }

    public static String getEditUrl(VitroRequest vreq) {
        return vreq.getContextPath() + EditConfigurationUtils.getEditUrlWithoutContext(vreq);
    }

    public static String getEditUrlWithoutContext(VitroRequest vreq) {
        return "/editRequestDispatch";
    }

    public static String getCancelUrlBase(VitroRequest vreq) {
        return vreq.getContextPath() + "/postEditCleanupController";
    }

    public static String getEditKey(VitroRequest vreq) {
        HttpSession session = vreq.getSession();
        String editKey = EditConfigurationVTwo.getEditKeyFromRequest((ServletRequest)vreq) == null ? EditConfigurationVTwo.newEditKey(session) : EditConfigurationVTwo.getEditKeyFromRequest((ServletRequest)vreq);
        return editKey;
    }

    public static boolean isDataProperty(String predicateUri, VitroRequest vreq) {
        if (predicateUri == null) {
            log.debug((Object)"Predicate URI is null so not data property");
            return false;
        }
        if (EditConfigurationUtils.isVitroLabel(predicateUri)) {
            return true;
        }
        DataProperty dataProp = vreq.getWebappDaoFactory().getDataPropertyDao().getDataPropertyByURI(predicateUri);
        return dataProp != null;
    }

    protected static String getDataPropKey(VitroRequest vreq) {
        return vreq.getParameter("datapropKey");
    }

    public static boolean isObjectProperty(String predicateUri, VitroRequest vreq) {
        if (predicateUri == null) {
            log.debug((Object)"Predicate URI is null so not object property");
            return false;
        }
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        ObjectProperty op = wdf.getObjectPropertyDao().getObjectPropertyByURI(predicateUri);
        DataProperty dp = wdf.getDataPropertyDao().getDataPropertyByURI(predicateUri);
        log.debug((Object)("For " + predicateUri + ", object property from dao null? " + (op == null) + " and data property  null?" + (dp == null)));
        return op != null && dp == null;
    }

    private static boolean isVitroLabel(String predicateUri) {
        return predicateUri.equals("http://www.w3.org/2000/01/rdf-schema#label");
    }

    public static DataPropertyStatement getDataPropertyStatement(VitroRequest vreq, HttpSession session, Integer dataHash, String predicateUri) {
        DataPropertyStatement dps = null;
        if (dataHash != 0) {
            OntModel model = ModelAccess.on(session.getServletContext()).getOntModel();
            dps = RdfLiteralHash.getPropertyStmtByHash(EditConfigurationUtils.getSubjectUri(vreq), predicateUri, dataHash, (Model)model);
        }
        return dps;
    }

    public static Integer getDataHash(VitroRequest vreq) {
        Integer dataHash = null;
        String datapropKey = EditConfigurationUtils.getDataPropKey(vreq);
        if (datapropKey != null && datapropKey.trim().length() > 0) {
            try {
                dataHash = Integer.parseInt(datapropKey);
            }
            catch (NumberFormatException ex) {
                log.error((Object)("Cannot decode incoming dataprop key str " + datapropKey + "as integer hash"));
            }
        }
        return dataHash;
    }

    public static Map<String, List<String>> getExistingLiteralValues(VitroRequest vreq, EditConfigurationVTwo editConfig) {
        Map<String, List<String>> literalsInScopeStringValues = EditConfigurationUtils.transformLiteralMap(editConfig.getLiteralsInScope());
        return literalsInScopeStringValues;
    }

    private static List<String> transformLiteralListToStringList(List<Literal> literalValues) {
        ArrayList<String> stringValues = new ArrayList<String>();
        if (literalValues != null) {
            for (Literal l : literalValues) {
                if (l == null) continue;
                stringValues.add(l.getValue().toString());
            }
        }
        return stringValues;
    }

    public static Map<String, List<String>> transformLiteralMap(Map<String, List<Literal>> map) {
        HashMap<String, List<String>> literalMapStringValues = new HashMap<String, List<String>>();
        for (String key : map.keySet()) {
            List<String> stringValues = EditConfigurationUtils.transformLiteralListToStringList(map.get(key));
            literalMapStringValues.put(key, stringValues);
        }
        return literalMapStringValues;
    }

    public static Map<String, List<String>> getExistingUriValues(EditConfigurationVTwo editConfig) {
        return editConfig.getUrisInScope();
    }

    public static String generateHTMLForElement(VitroRequest vreq, String fieldName, EditConfigurationVTwo editConfig) {
        String html = "";
        Configuration fmConfig = FreemarkerConfiguration.getConfig((HttpServletRequest)vreq);
        FieldVTwo field = editConfig == null ? null : editConfig.getField(fieldName);
        MultiValueEditSubmission editSub = EditSubmissionUtils.getEditSubmissionFromSession(vreq.getSession(), editConfig);
        if (field != null && field.getEditElement() != null) {
            html = field.getEditElement().draw(fieldName, editConfig, editSub, fmConfig);
        }
        return html;
    }

    public static List<String> copy(List<String> list) {
        ArrayList<String> copyList = new ArrayList<String>();
        for (String l : list) {
            copyList.add(new String(l));
        }
        return copyList;
    }

    public static Map<String, String> copyMap(Map<String, String> source) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set keys = map.keySet();
        for (String key : keys) {
            if (source.get(key) != null) {
                map.put(new String(key), new String(source.get(key)));
                continue;
            }
            map.put(new String(key), null);
        }
        return map;
    }

    public static Map<String, List<String>> copyListMap(Map<String, List<String>> source) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Set keys = map.keySet();
        for (String key : keys) {
            List<String> vals = map.get(key);
            map.put(new String(key), EditConfigurationUtils.copy(vals));
        }
        return map;
    }

    public static EditConfigurationVTwo getEditConfiguration(HttpServletRequest request) {
        HttpSession session = request.getSession();
        EditConfigurationVTwo editConfiguration = EditConfigurationVTwo.getConfigFromSession(session, request);
        return editConfiguration;
    }
}

