/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.InsertException;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DependentResourceDeleteJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.AdditionsAndRetractions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditN3GeneratorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionVTwoPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.NewURIMaker;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.Lock;

public class ProcessRdfForm {
    private NewURIMaker newURIMaker;
    private EditN3GeneratorVTwo populator;
    private Map<String, String> urisForNewResources = null;
    private static N3ParseType OPTIONAL = N3ParseType.OPTIONAL;
    private static N3ParseType REQUIRED = N3ParseType.REQUIRED;
    private static Log log = LogFactory.getLog(ProcessRdfForm.class);

    public ProcessRdfForm(EditConfigurationVTwo config, NewURIMaker newURIMaker) {
        this.newURIMaker = newURIMaker;
        this.populator = config.getN3Generator();
    }

    public AdditionsAndRetractions process(EditConfigurationVTwo configuration, MultiValueEditSubmission submission, VitroRequest vreq) throws Exception {
        log.debug((Object)("configuration:\n" + configuration.toString()));
        log.debug((Object)("submission:\n" + submission.toString()));
        this.applyEditSubmissionPreprocessors(configuration, submission, vreq);
        AdditionsAndRetractions changes = configuration.isUpdate() ? this.editExistingStatements(configuration, submission) : this.createNewStatements(configuration, submission);
        changes = ProcessRdfForm.getMinimalChanges(changes);
        ProcessRdfForm.logChanges(configuration, changes);
        return changes;
    }

    private AdditionsAndRetractions createNewStatements(EditConfigurationVTwo configuration, MultiValueEditSubmission submission) throws Exception {
        log.debug((Object)"in createNewStatements()");
        List<String> requiredN3 = configuration.getN3Required();
        List<String> optionalN3 = configuration.getN3Optional();
        this.subInValuesToN3(configuration, submission, requiredN3, optionalN3, null, null);
        return this.parseN3ToChange(requiredN3, optionalN3, null, null);
    }

    protected void substituteInSubPredObjURIs(EditConfigurationVTwo configuration, List<String> ... n3StrLists) {
        Map<String, String> valueMap = ProcessRdfForm.getSubPedObjVarMap(configuration);
        for (List<String> n3s : n3StrLists) {
            this.populator.subInUris(valueMap, n3s);
        }
    }

    protected AdditionsAndRetractions editExistingStatements(EditConfigurationVTwo editConfig, MultiValueEditSubmission submission) throws Exception {
        log.debug((Object)("editing an existing resource: " + editConfig.getObject()));
        List<String> N3RequiredAssert = editConfig.getN3Required();
        List<String> N3OptionalAssert = editConfig.getN3Optional();
        List<String> N3RequiredRetract = editConfig.getN3Required();
        List<String> N3OptionalRetract = editConfig.getN3Optional();
        this.subInValuesToN3(editConfig, submission, N3RequiredAssert, N3OptionalAssert, N3RequiredRetract, N3OptionalRetract);
        return this.parseN3ToChange(N3RequiredAssert, N3OptionalAssert, N3RequiredRetract, N3OptionalRetract);
    }

    protected void subInValuesToN3(EditConfigurationVTwo editConfig, MultiValueEditSubmission submission, List<String> requiredAsserts, List<String> optionalAsserts, List<String> requiredRetracts, List<String> optionalRetracts) throws InsertException {
        List<String> URLToReturnTo = Arrays.asList(submission.getEntityToReturnTo());
        this.urisForNewResources = this.URIsForNewRsources(editConfig, this.newURIMaker);
        this.substituteInForcedNewURIs(this.urisForNewResources, submission.getUrisFromForm(), requiredAsserts, optionalAsserts, URLToReturnTo);
        this.logSubstitue("Added form URIs that required new URIs", requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts);
        this.substituteInMultiURIs(submission.getUrisFromForm(), requiredAsserts, optionalAsserts, URLToReturnTo);
        this.logSubstitue("Added form URIs", requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts);
        this.substituteInMultiLiterals(submission.getLiteralsFromForm(), requiredAsserts, optionalAsserts, URLToReturnTo);
        this.logSubstitue("Added form Literals", requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts);
        this.substituteInSubPredObjURIs(editConfig, requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts, URLToReturnTo);
        this.logSubstitue("Added sub, pred and obj URIs", requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts);
        this.substituteInMultiURIs(editConfig.getUrisInScope(), requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts, URLToReturnTo);
        this.logSubstitue("Added existing URIs", requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts);
        this.substituteInMultiLiterals(editConfig.getLiteralsInScope(), requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts, URLToReturnTo);
        this.logSubstitue("Added existing Literals", requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts);
        this.substituteInURIs(this.urisForNewResources, requiredAsserts, optionalAsserts, URLToReturnTo);
        this.logSubstitue("Added URIs for new Resources", requiredAsserts, optionalAsserts, requiredRetracts, optionalRetracts);
        submission.setEntityToReturnTo(URLToReturnTo.get(0));
    }

    public static AdditionsAndRetractions addDependentDeletes(AdditionsAndRetractions changes, Model queryModel) {
        Model depResRetractions = DependentResourceDeleteJena.getDependentResourceDeleteForChange(changes.getAdditions(), changes.getRetractions(), queryModel);
        changes.getRetractions().add(depResRetractions);
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyChangesToWriteModel(AdditionsAndRetractions changes, Model queryModel, Model writeModel, String editorUri) {
        Lock lock = null;
        try {
            lock = writeModel.getLock();
            lock.enterCriticalSection(false);
            if (writeModel instanceof OntModel) {
                ((OntModel)writeModel).getBaseModel().notifyEvent((Object)new EditEvent(editorUri, true));
            }
            writeModel.add(changes.getAdditions());
            writeModel.remove(changes.getRetractions());
        }
        catch (Throwable t) {
            log.error((Object)("error adding edit change n3required model to in memory model \n" + t.getMessage()));
        }
        finally {
            if (writeModel instanceof OntModel) {
                ((OntModel)writeModel).getBaseModel().notifyEvent((Object)new EditEvent(editorUri, false));
            }
            lock.leaveCriticalSection();
        }
    }

    protected AdditionsAndRetractions parseN3ToChange(List<String> requiredAdds, List<String> optionalAdds, List<String> requiredDels, List<String> optionalDels) throws Exception {
        List<Model> adds = ProcessRdfForm.parseN3ToRDF(requiredAdds, REQUIRED);
        adds.addAll(ProcessRdfForm.parseN3ToRDF(optionalAdds, OPTIONAL));
        ArrayList<Model> retracts = new ArrayList<Model>();
        if (requiredDels != null && optionalDels != null) {
            retracts.addAll(ProcessRdfForm.parseN3ToRDF(requiredDels, REQUIRED));
            retracts.addAll(ProcessRdfForm.parseN3ToRDF(optionalDels, OPTIONAL));
        }
        return new AdditionsAndRetractions(adds, retracts);
    }

    protected static List<Model> parseN3ToRDF(List<String> n3Strings, N3ParseType parseType) throws Exception {
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<Model> rdfModels = new ArrayList<Model>();
        for (String n3 : n3Strings) {
            try {
                Model model = ModelFactory.createDefaultModel();
                StringReader reader = new StringReader(n3);
                model.read((Reader)reader, "", "N3");
                rdfModels.add(model);
            }
            catch (Throwable t) {
                errorMessages.add(t.getMessage() + "\nN3: \n" + n3 + "\n");
            }
        }
        String errors = "";
        for (String errorMsg : errorMessages) {
            errors = errors + errorMsg + '\n';
        }
        if (!errorMessages.isEmpty()) {
            if (REQUIRED.equals((Object)parseType)) {
                throw new Exception("Errors processing required N3. The EditConfiguration should be setup so that if a submission passes validation, there will not be errors in the required N3.\n" + errors);
            }
            if (OPTIONAL.equals((Object)parseType)) {
                log.debug((Object)"Some Optional N3 did not parse, if a optional N3 does not parse it will be ignored.  This allows optional parts of a form submission to remain unfilled out and then the optional N3 does not get values subsituted in fromthe form submission values.  It may also be the case that there are unintentional syntax errors the optional N3.");
                log.debug((Object)errors);
            }
        }
        return rdfModels;
    }

    protected void logSubstitue(String msg, List<String> requiredAsserts, List<String> optionalAsserts, List<String> requiredRetracts, List<String> optionalRetracts) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug((Object)msg);
        this.logSubstitueN3(msg, requiredAsserts, "required assertions");
        this.logSubstitueN3(msg, optionalAsserts, "optional assertions");
        this.logSubstitueN3(msg, requiredRetracts, "required retractions");
        this.logSubstitueN3(msg, optionalRetracts, "optional retractions");
    }

    private void logSubstitueN3(String msg, List<String> n3, String label) {
        if (n3 == null || n3.size() == 0) {
            return;
        }
        String out = label + ":\n";
        for (String str : n3) {
            out = out + "    " + str + "\n";
        }
        log.debug((Object)out);
    }

    private static Map<String, String> getSubPedObjVarMap(EditConfigurationVTwo configuration) {
        HashMap<String, String> varToValue = new HashMap<String, String>();
        String varNameForSub = configuration.getVarNameForSubject();
        if (varNameForSub != null && !varNameForSub.isEmpty()) {
            varToValue.put(varNameForSub, configuration.getSubjectUri());
        } else {
            log.debug((Object)"no varNameForSubject found in configuration");
        }
        String varNameForPred = configuration.getVarNameForPredicate();
        if (varNameForPred != null && !varNameForPred.isEmpty()) {
            varToValue.put(varNameForPred, configuration.getPredicateUri());
        } else {
            log.debug((Object)"no varNameForPredicate found in configuration");
        }
        String varNameForObj = configuration.getVarNameForObject();
        if (varNameForObj != null && !varNameForObj.isEmpty()) {
            varToValue.put(varNameForObj, configuration.getObject());
        } else {
            log.debug((Object)"no varNameForObject found in configuration");
        }
        return varToValue;
    }

    protected static AdditionsAndRetractions getMinimalChanges(AdditionsAndRetractions changes) {
        Model allPossibleAssertions = changes.getAdditions();
        Model allPossibleRetractions = changes.getRetractions();
        Model assertions = allPossibleAssertions.difference(allPossibleRetractions);
        Model retractions = allPossibleRetractions.difference(allPossibleAssertions);
        return new AdditionsAndRetractions(assertions, retractions);
    }

    private void applyEditSubmissionPreprocessors(EditConfigurationVTwo configuration, MultiValueEditSubmission submission, VitroRequest vreq) {
        List<EditSubmissionVTwoPreprocessor> preprocessors = configuration.getEditSubmissionPreprocessors();
        if (preprocessors != null) {
            for (EditSubmissionVTwoPreprocessor p : preprocessors) {
                p.preprocess(submission, vreq);
            }
        }
    }

    public Map<String, String> URIsForNewRsources(EditConfigurationVTwo configuration, NewURIMaker newURIMaker) throws InsertException {
        Map<String, String> newResources = configuration.getNewResources();
        HashMap<String, String> varToNewURIs = new HashMap<String, String>();
        for (String key : newResources.keySet()) {
            String prefix = newResources.get(key);
            String uri = newURIMaker.getUnusedNewURI(prefix);
            varToNewURIs.put(key, uri);
        }
        log.debug((Object)("URIs for new resources: " + varToNewURIs));
        return varToNewURIs;
    }

    private static void logChanges(EditConfigurationVTwo configuration, AdditionsAndRetractions changes) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Changes for edit " + configuration.getEditKey() + "\n" + changes.toString()));
        }
    }

    private void substituteInMultiLiterals(Map<String, List<Literal>> literalsFromForm, List<String> ... n3StrLists) {
        for (List<String> n3s : n3StrLists) {
            this.populator.subInMultiLiterals(literalsFromForm, n3s);
        }
    }

    private void substituteInMultiURIs(Map<String, List<String>> multiUris, List<String> ... n3StrLists) {
        for (List<String> n3s : n3StrLists) {
            if (n3s == null) continue;
            this.populator.subInMultiUris(multiUris, n3s);
        }
    }

    private void substituteInURIs(Map<String, String> uris, List<String> ... n3StrLists) {
        for (List<String> n3s : n3StrLists) {
            if (n3s == null) continue;
            this.populator.subInUris(uris, n3s);
        }
    }

    private void substituteInForcedNewURIs(Map<String, String> urisForNewResources, Map<String, List<String>> urisFromForm, List<String> requiredAsserts, List<String> optionalAsserts, List<String> uRLToReturnTo) {
        HashMap<String, List<String>> newUris = new HashMap<String, List<String>>();
        Iterator<String> keyIterator = urisFromForm.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next().toString();
            if (!urisFromForm.get(key).contains(">NEW URI REQUIRED<")) continue;
            String newUri = urisForNewResources.get(key);
            ArrayList<String> newUrisForKey = new ArrayList<String>();
            newUrisForKey.add(newUri);
            newUris.put(key, newUrisForKey);
        }
        if (newUris.size() > 0) {
            this.substituteInMultiURIs(newUris, requiredAsserts, optionalAsserts, uRLToReturnTo);
        }
    }

    private static enum N3ParseType {
        OPTIONAL,
        REQUIRED;

    }
}

