/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.modules.tboxreasoner.TBoxReasonerStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndividualsViaVClassOptions
implements FieldOptions {
    public static final String LEFT_BLANK = "";
    protected List<String> vclassURIs;
    protected String defaultOptionLabel;

    public IndividualsViaVClassOptions(String ... vclassURIs) throws Exception {
        if (vclassURIs == null) {
            throw new Exception("vclassURIs must not be null or empty ");
        }
        this.vclassURIs = new ArrayList<String>(vclassURIs.length);
        for (int i = 0; i < vclassURIs.length; ++i) {
            if (vclassURIs[i] == null || vclassURIs[i].trim().isEmpty()) continue;
            this.vclassURIs.add(vclassURIs[i]);
        }
    }

    public FieldOptions setDefaultOptionLabel(String label) {
        this.defaultOptionLabel = label;
        return this;
    }

    @Override
    public Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wDaoFact) throws Exception {
        HashMap<String, Individual> individualMap = new HashMap<String, Individual>();
        for (String vclassURI : this.vclassURIs) {
            individualMap.putAll(this.getIndividualsForClass(vclassURI, wDaoFact));
        }
        ArrayList individuals = new ArrayList();
        individuals.addAll(individualMap.values());
        Collections.sort(individuals);
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        if (this.defaultOptionLabel != null) {
            optionsMap.put(LEFT_BLANK, this.defaultOptionLabel);
        }
        if (individuals.size() == 0) {
            optionsMap.putAll(this.notFoundMsg());
        } else {
            for (Individual ind : individuals) {
                if (ind.getURI() == null) continue;
                optionsMap.put(ind.getURI(), ind.getName().trim());
            }
        }
        return optionsMap;
    }

    private Map<? extends String, ? extends String> notFoundMsg() {
        String msg = "No individuals found for " + (this.vclassURIs.size() > 1 ? "types" : "type");
        for (String uri : this.vclassURIs) {
            msg = msg + " " + uri;
        }
        return Collections.singletonMap(LEFT_BLANK, msg);
    }

    protected Map<String, Individual> getIndividualsForClass(String vclassURI, WebappDaoFactory wDaoFact) {
        HashMap<String, Individual> individualMap = new HashMap<String, Individual>();
        IndividualDao indDao = wDaoFact.getIndividualDao();
        List<Individual> indsForClass = indDao.getIndividualsByVClassURI(vclassURI, -1, -1);
        for (Individual ind : indsForClass) {
            if (ind.getURI() == null) continue;
            individualMap.put(ind.getURI(), ind);
        }
        individualMap.putAll(this.addWhenMissingInference(vclassURI, wDaoFact));
        return individualMap;
    }

    protected boolean isReasoningAvailable() {
        TBoxReasonerStatus status = ApplicationUtils.instance().getTBoxReasonerModule().getStatus();
        return status.isConsistent() && !status.isInErrorState();
    }

    protected Map<String, Individual> addWhenMissingInference(String classUri, WebappDaoFactory wDaoFact) {
        boolean inferenceAvailable = this.isReasoningAvailable();
        HashMap<String, Individual> individualMap = new HashMap<String, Individual>();
        if (!inferenceAvailable) {
            for (String subclassURI : wDaoFact.getVClassDao().getAllSubClassURIs(classUri)) {
                for (Individual ind : wDaoFact.getIndividualDao().getIndividualsByVClassURI(subclassURI, -1, -1)) {
                    if (ind.getURI() == null) continue;
                    individualMap.put(ind.getURI(), ind);
                }
            }
        }
        return individualMap;
    }

    @Override
    public Comparator<String[]> getCustomComparator() {
        return null;
    }
}

