/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RdfTypeOptions
implements FieldOptions {
    String[] typeURIs;

    public RdfTypeOptions(String ... superClassURIs) throws Exception {
        if (superClassURIs == null) {
            throw new Exception("superClassURIs must be supplied to constructor.");
        }
        this.typeURIs = superClassURIs;
    }

    @Override
    public Map<String, String> getOptions(EditConfigurationVTwo editConfig, String fieldName, WebappDaoFactory wdf) {
        HashMap<String, String> uriToLabel = new HashMap<String, String>();
        for (int i = 0; i < this.typeURIs.length; ++i) {
            String uri = this.typeURIs[i];
            VClass vc = wdf.getVClassDao().getVClassByURI(uri);
            if (vc == null) {
                uriToLabel.put(uri, uri);
                continue;
            }
            uriToLabel.put(uri, vc.getPickListName());
            List<String> subclassUris = wdf.getVClassDao().getAllSubClassURIs(uri);
            if (subclassUris == null) continue;
            for (String subUri : subclassUris) {
                VClass subVc = wdf.getVClassDao().getVClassByURI(subUri);
                if (vc != null) {
                    uriToLabel.put(subUri, subVc.getPickListName());
                    continue;
                }
                uriToLabel.put(subUri, subUri);
            }
        }
        return uriToLabel;
    }

    @Override
    public Comparator<String[]> getCustomComparator() {
        return null;
    }
}

