/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterN3;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterN3Map;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessDataGetterN3Utils {
    private static final Log log = LogFactory.getLog(ProcessDataGetterN3Utils.class);

    public static ProcessDataGetterN3 getDataGetterProcessorN3(String dataGetterClass, JSONObject jsonObject) {
        HashMap<String, String> map = ProcessDataGetterN3Map.getDataGetterTypeToProcessorMap();
        if (map.containsKey(dataGetterClass)) {
            String processorClass = map.get(dataGetterClass);
            try {
                ProcessDataGetterN3 pn = ProcessDataGetterN3Utils.instantiateClass(processorClass, jsonObject);
                return pn;
            }
            catch (Exception ex) {
                log.error((Object)("Exception occurred in trying to get processor class for n3 for " + dataGetterClass), (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    private static ProcessDataGetterN3 instantiateClass(String processorClass, JSONObject jsonObject) {
        ProcessDataGetterN3 pn = null;
        try {
            Constructor<?>[] ctList;
            Class<?> clz = Class.forName(processorClass);
            for (Constructor<?> ct : ctList = clz.getConstructors()) {
                Class<?>[] parameterTypes = ct.getParameterTypes();
                pn = parameterTypes.length > 0 && parameterTypes[0].isAssignableFrom(jsonObject.getClass()) ? (ProcessDataGetterN3)ct.newInstance(jsonObject) : (ProcessDataGetterN3)ct.newInstance(new Object[0]);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Error occurred instantiating " + processorClass), (Throwable)ex);
        }
        return pn;
    }
}

