/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterAbstract;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessFixedHTMLN3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class ProcessSearchIndividualsDataGetterN3
extends ProcessDataGetterAbstract {
    private static String classType = "java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.SearchIndividualsDataGetter";
    private Log log = LogFactory.getLog(ProcessFixedHTMLN3.class);

    @Override
    public List<String> retrieveN3Required(int counter) {
        String dataGetterVar = this.getDataGetterVar(counter);
        String classTypeVar = this.getN3VarName(classTypeVarBase, counter);
        String n3 = dataGetterVar + " a " + classTypeVar + "; \n" + "display:saveToVar " + this.getN3VarName("saveToVar", counter) + "; \n" + "display:hasVClassId " + this.getN3VarName("vclassUri", counter) + " .";
        ArrayList<String> requiredList = new ArrayList<String>();
        requiredList.add(this.getPrefixes() + n3);
        return requiredList;
    }

    @Override
    public List<String> retrieveN3Optional(int counter) {
        return null;
    }

    @Override
    public List<String> retrieveLiteralsOnForm(int counter) {
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add(this.getVarName("saveToVar", counter));
        return literalsOnForm;
    }

    @Override
    public List<String> retrieveUrisOnForm(int counter) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        urisOnForm.add(this.getVarName("vclassUri", counter));
        urisOnForm.add(this.getVarName(classTypeVarBase, counter));
        return urisOnForm;
    }

    @Override
    public List<FieldVTwo> retrieveFields(int counter) {
        ArrayList<FieldVTwo> fields = new ArrayList<FieldVTwo>();
        fields.add(new FieldVTwo().setName(this.getVarName("saveToVar", counter)));
        fields.add(new FieldVTwo().setName(this.getVarName("vclassUri", counter)));
        fields.add(new FieldVTwo().setName(this.getVarName(classTypeVarBase, counter)));
        return fields;
    }

    @Override
    public List<String> getLiteralVarNamesBase() {
        return Arrays.asList("saveToVar");
    }

    @Override
    public List<String> getUriVarNamesBase() {
        return Arrays.asList(classTypeVarBase, "vclassUri");
    }

    @Override
    public void populateExistingValues(String dataGetterURI, int counter, OntModel queryModel) {
        this.populateExistingDataGetterURI(dataGetterURI, counter);
        this.populateExistingClassType(this.getClassType(), counter);
        String querystr = this.getExistingValuesSparqlQuery(dataGetterURI);
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Literal saveToVarLiteral = qs.getLiteral("saveToVar");
                Resource vclassUriResource = qs.getResource("vclassUri");
                this.existingLiteralValues.put(this.getVarName("saveToVar", counter), new ArrayList<Literal>(Arrays.asList(saveToVarLiteral)));
                this.existingUriValues.put(this.getVarName("vclassUri", counter), new ArrayList<String>(Arrays.asList(vclassUriResource.getURI())));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
    }

    protected String getExistingValuesSparqlQuery(String dataGetterURI) {
        String query = this.getSparqlPrefix() + " SELECT ?saveToVar ?vclassUri WHERE {" + "<" + dataGetterURI + "> display:saveToVar ?saveToVar . \n" + "<" + dataGetterURI + "> display:hasVClassId ?vclassUri . \n" + "}";
        return query;
    }

    @Override
    public JSONObject getExistingValuesJSON(String dataGetterURI, OntModel queryModel, ServletContext context) {
        JSONObject jObject = new JSONObject();
        jObject.element("dataGetterClass", (Object)classType);
        jObject.element(classTypeVarBase, (Object)classType);
        String querystr = this.getExistingValuesSparqlQuery(dataGetterURI);
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Literal saveToVarLiteral = qs.getLiteral("saveToVar");
                Resource vclassUriResource = qs.getResource("vclassUri");
                String vclassUriString = vclassUriResource.getURI();
                jObject.element("saveToVar", (Object)saveToVarLiteral.getString());
                jObject.element("vclassUri", (Object)vclassUriString);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
        return jObject;
    }

    public String replaceQuotes(String inputStr) {
        return inputStr.replaceAll("'", "&#39;").replaceAll("\"", "&quot;");
    }

    @Override
    public String getClassType() {
        return classType;
    }
}

