/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class CharsetEncodingFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        this.setCharacterEncodingOnRequest(req);
        this.setContentTypeOnResponse(req, servletResponse);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void setCharacterEncodingOnRequest(HttpServletRequest req) throws UnsupportedEncodingException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            req.setCharacterEncoding("UTF-8");
        }
    }

    private void setContentTypeOnResponse(HttpServletRequest req, ServletResponse servletResponse) {
        if (servletResponse.getContentType() != null) {
            return;
        }
        String uri = req.getRequestURI();
        if (!this.hasExtension(uri)) {
            servletResponse.setContentType("text/html;charset=UTF-8");
            return;
        }
        String typeFromContext = req.getSession().getServletContext().getMimeType(uri);
        if (typeFromContext == null) {
            servletResponse.setContentType("text/html;charset=UTF-8");
            return;
        }
        servletResponse.setContentType(typeFromContext);
        servletResponse.setCharacterEncoding("UTF-8");
    }

    private boolean hasExtension(String uri) {
        return uri.matches(".+\\.[^/]+$");
    }

    public void destroy() {
    }
}

