/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.filters;

import edu.cornell.mannlib.vitro.webapp.controller.freemarker.PageController;
import edu.cornell.mannlib.vitro.webapp.dao.PageDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageRoutingFilter
implements Filter {
    protected FilterConfig filterConfig;
    private static final Log log = LogFactory.getLog(PageRoutingFilter.class);
    protected static final String URL_PART_PATTERN = "(/[^/]*).*";
    protected static final String PAGE_CONTROLLER_NAME = "PageController";
    protected static final String HOME_CONTROLLER_NAME = "HomePageController";
    protected final Pattern urlPartPattern = Pattern.compile("(/[^/]*).*");

    public void init(FilterConfig arg0) throws ServletException {
        this.filterConfig = arg0;
        log.debug((Object)"pageRoutingFilter setup");
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain chain) throws IOException, ServletException {
        ServletContext ctx = this.filterConfig.getServletContext();
        PageDao pageDao = ModelAccess.on(ctx).getWebappDaoFactory().getPageDao();
        Map<String, String> urlMappings = pageDao.getPageMappings();
        HttpServletResponse response = (HttpServletResponse)arg1;
        HttpServletRequest req = (HttpServletRequest)arg0;
        String path = req.getRequestURI().substring(req.getContextPath().length());
        Matcher m = this.urlPartPattern.matcher(path);
        if (m.matches() && m.groupCount() >= 1) {
            String path1stPart = m.group(1);
            String pageUri = urlMappings.get(path1stPart);
            if (pageUri == null) {
                pageUri = urlMappings.get("/" + path1stPart);
            }
            if (pageUri != null && !pageUri.isEmpty()) {
                log.debug((Object)(path + "is a request to a page defined in the display model as " + pageUri));
                PageController.putPageUri(req, pageUri);
                String controllerName = this.getControllerToForwardTo(req, pageUri, pageDao);
                log.debug((Object)(path + " is being forwarded to controller " + controllerName));
                RequestDispatcher rd = ctx.getNamedDispatcher(controllerName);
                if (rd == null) {
                    log.error((Object)(path + " should be forwarded to controller " + controllerName + " but there " + "is no servlet named that defined for the web application in web.xml"));
                }
                rd.forward((ServletRequest)req, (ServletResponse)response);
            } else if ("/".equals(path) || path.isEmpty()) {
                log.debug((Object)("url '" + path + "' is being forward to home controller"));
                RequestDispatcher rd = ctx.getNamedDispatcher(HOME_CONTROLLER_NAME);
                rd.forward((ServletRequest)req, (ServletResponse)response);
            } else {
                this.doNonDisplayPage(path, arg0, arg1, chain);
            }
        } else {
            this.doNonDisplayPage(path, arg0, arg1, chain);
        }
    }

    protected void doNonDisplayPage(String path, ServletRequest arg0, ServletResponse arg1, FilterChain chain) throws IOException, ServletException {
        log.debug((Object)(path + "this isn't a request to a page defined in the display model, handle it normally."));
        chain.doFilter(arg0, arg1);
    }

    protected String getControllerToForwardTo(HttpServletRequest req, String pageUri, PageDao pageDao) {
        String homePageUri = pageDao.getHomePageUri();
        if (pageUri != null && pageUri.equals(homePageUri)) {
            return HOME_CONTROLLER_NAME;
        }
        return PAGE_CONTROLLER_NAME;
    }

    public void destroy() {
    }
}

