/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VitroResourceBundle
extends ResourceBundle {
    private static final Log log = LogFactory.getLog(VitroResourceBundle.class);
    private static final String FILE_FLAG = "@@file ";
    private static final String MESSAGE_FILE_NOT_FOUND = "File {1} not found for property {0}.";
    private final String bundleName;
    private final ServletContext ctx;
    private final String appI18nPath;
    private final String themeI18nPath;
    private final ResourceBundle.Control control;
    private final Properties defaults;
    private final Properties properties;

    public static VitroResourceBundle getBundle(String bundleName, ServletContext ctx, String appI18nPath, String themeI18nPath, ResourceBundle.Control control) {
        try {
            return new VitroResourceBundle(bundleName, ctx, appI18nPath, themeI18nPath, control);
        }
        catch (FileNotFoundException e) {
            log.debug((Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
            return null;
        }
    }

    private VitroResourceBundle(String bundleName, ServletContext ctx, String appI18nPath, String themeI18nPath, ResourceBundle.Control control) throws IOException {
        this.bundleName = bundleName;
        this.ctx = ctx;
        this.appI18nPath = appI18nPath;
        this.themeI18nPath = themeI18nPath;
        this.control = control;
        this.defaults = new Properties();
        this.properties = new Properties(this.defaults);
        this.loadProperties();
        this.loadReferencedFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws IOException {
        InputStreamReader reader;
        FileInputStream stream;
        String resourceName = this.control.toResourceName(this.bundleName, "properties");
        String defaultsPath = this.joinPath(this.appI18nPath, resourceName);
        String propertiesPath = this.joinPath(this.themeI18nPath, resourceName);
        File defaultsFile = this.locateFile(defaultsPath);
        File propertiesFile = this.locateFile(propertiesPath);
        if (defaultsFile == null && propertiesFile == null) {
            throw new FileNotFoundException("Property file not found at '" + defaultsPath + "' or '" + propertiesPath + "'");
        }
        if (defaultsFile != null) {
            log.debug((Object)("Loading bundle '" + this.bundleName + "' defaults from '" + defaultsPath + "'"));
            stream = new FileInputStream(defaultsFile);
            reader = new InputStreamReader((InputStream)stream, "UTF-8");
            try {
                this.defaults.load(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        if (propertiesFile != null) {
            log.debug((Object)("Loading bundle '" + this.bundleName + "' overrides from '" + propertiesPath + "'"));
            stream = new FileInputStream(propertiesFile);
            reader = new InputStreamReader((InputStream)stream, "UTF-8");
            try {
                this.properties.load(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
    }

    private void loadReferencedFiles() throws IOException {
        for (String key : this.properties.stringPropertyNames()) {
            String value = this.properties.getProperty(key);
            if (!value.startsWith(FILE_FLAG)) continue;
            String filepath = value.substring(FILE_FLAG.length()).trim();
            this.loadReferencedFile(key, filepath);
        }
    }

    private void loadReferencedFile(String key, String filepath) throws IOException {
        String appFilePath = this.joinPath(this.appI18nPath, filepath);
        String themeFilePath = this.joinPath(this.themeI18nPath, filepath);
        File appFile = this.locateFile(appFilePath);
        File themeFile = this.locateFile(themeFilePath);
        if (themeFile != null) {
            this.properties.setProperty(key, FileUtils.readFileToString((File)themeFile, (String)"UTF-8"));
        } else if (appFile != null) {
            this.properties.setProperty(key, FileUtils.readFileToString((File)appFile, (String)"UTF-8"));
        } else {
            String message = MessageFormat.format(MESSAGE_FILE_NOT_FOUND, key, themeFilePath, appFilePath);
            this.properties.setProperty(key, message);
            log.warn((Object)message);
        }
    }

    private String joinPath(String root, String twig) {
        if (root.charAt(root.length() - 1) == File.separatorChar || twig.charAt(0) == File.separatorChar) {
            return root + twig;
        }
        return root + File.separatorChar + twig;
    }

    private File locateFile(String path) {
        String realPath = this.ctx.getRealPath(path);
        if (realPath == null) {
            log.debug((Object)("No real path for '" + path + "'"));
            return null;
        }
        File f = new File(realPath);
        if (!f.isFile()) {
            log.debug((Object)("No file at '" + realPath + "'"));
            return null;
        }
        if (!f.canRead()) {
            log.error((Object)("Can't read the file at '" + realPath + "'"));
            return null;
        }
        log.debug((Object)("Located file '" + path + "' at '" + realPath + "'"));
        return f;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.properties.propertyNames();
    }

    @Override
    protected Object handleGetObject(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            log.debug((Object)(this.bundleName + " has no value for '" + key + "'"));
        }
        return value;
    }
}

