/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.freemarker;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.DeepUnwrap;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nStringTemplateModel
implements TemplateMethodModelEx,
TemplateScalarModel {
    private static final Log log = LogFactory.getLog(I18nStringTemplateModel.class);
    private final String bundleName;
    private final String key;
    private final String textString;

    public I18nStringTemplateModel(String bundleName, String key, String textString) {
        this.bundleName = bundleName;
        this.key = key;
        this.textString = textString;
    }

    public String getAsString() throws TemplateModelException {
        return this.textString;
    }

    public Object exec(List args) throws TemplateModelException {
        log.debug((Object)("Formatting string '" + this.key + "' from bundle '" + this.bundleName + "' with these arguments: " + args));
        if (args.isEmpty()) {
            return this.textString;
        }
        Object[] unwrappedArgs = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            unwrappedArgs[i] = DeepUnwrap.unwrap((TemplateModel)((TemplateModel)args.get(i)));
        }
        try {
            return MessageFormat.format(this.textString, unwrappedArgs);
        }
        catch (Exception e) {
            String message = "Can't format '" + this.key + "' from bundle '" + this.bundleName + "', wrong argument types: " + args + " for message format'" + this.textString + "'";
            log.warn((Object)message);
            return message;
        }
    }
}

