/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.i18n.selection;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class LocaleSelectionSetup
implements ServletContextListener {
    public static final String PROPERTY_FORCE_LOCALE = "languages.forceLocale";
    public static final String PROPERTY_SELECTABLE_LOCALES = "languages.selectableLocales";
    private ServletContext ctx;
    private StartupStatus ss;
    private ConfigurationProperties props;
    private String forceString;
    private String selectableString;

    public void contextInitialized(ServletContextEvent sce) {
        this.ctx = sce.getServletContext();
        this.ss = StartupStatus.getBean(this.ctx);
        this.props = ConfigurationProperties.getBean(sce);
        this.readProperties();
        if (this.isForcing() && this.hasSelectables()) {
            this.warnAboutOverride();
        }
        if (this.isForcing()) {
            this.forceLocale();
        } else if (this.hasSelectables()) {
            this.setUpSelections();
        } else {
            this.reportNoLocales();
        }
    }

    private void readProperties() {
        this.forceString = this.props.getProperty(PROPERTY_FORCE_LOCALE, "");
        this.selectableString = this.props.getProperty(PROPERTY_SELECTABLE_LOCALES, "");
    }

    private boolean isForcing() {
        return StringUtils.isNotBlank((CharSequence)this.forceString);
    }

    private boolean hasSelectables() {
        return StringUtils.isNotBlank((CharSequence)this.selectableString);
    }

    private void warnAboutOverride() {
        this.ss.warning(this, "'languages.forceLocale' will override 'languages.selectableLocales'.");
    }

    private void forceLocale() {
        try {
            Locale forceLocale = this.buildLocale(this.forceString);
            SelectedLocale.setForcedLocale(this.ctx, forceLocale);
            this.ssInfo("Setting forced locale to '" + forceLocale + "'.");
        }
        catch (IllegalArgumentException e) {
            this.ssWarning("Problem in 'languages.forceLocale': " + e.getMessage());
        }
    }

    private void setUpSelections() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String string : this.splitSelectables()) {
            try {
                locales.add(this.buildLocale(string));
            }
            catch (IllegalArgumentException e) {
                this.ssWarning("Problem in 'languages.selectableLocales': " + e.getMessage());
            }
        }
        SelectedLocale.setSelectableLocales(this.ctx, locales);
        this.ssInfo("Setting selectable locales to '" + locales + "'.");
    }

    private String[] splitSelectables() {
        return this.selectableString.split("\\s*,\\s*");
    }

    private void reportNoLocales() {
        this.ssInfo("There is no Locale information.");
    }

    private void ssInfo(String message) {
        this.ss.info(this, message + this.showPropertyValues());
    }

    private void ssWarning(String message) {
        this.ss.warning(this, message + this.showPropertyValues());
    }

    private String showPropertyValues() {
        return " In runtime.properties, 'languages.forceLocale' is set to '" + this.forceString + "', '" + PROPERTY_SELECTABLE_LOCALES + "' is set to '" + this.selectableString + "'";
    }

    private Locale buildLocale(String localeString) throws IllegalArgumentException {
        if ("".equals(localeString)) {
            throw new IllegalArgumentException("Invalid locale format");
        }
        Locale locale = LocaleUtils.toLocale((String)localeString);
        if (!"es_GO".equals(localeString) && !LocaleUtils.isAvailableLocale((Locale)locale)) {
            this.ssWarning("'" + locale + "' is not a recognized locale.");
        }
        return locale;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }
}

