/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractBulkUpdater;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.rdf.model.Model;

public class RDFServiceBulkUpdater
extends AbstractBulkUpdater {
    RDFServiceGraph graph;

    public RDFServiceBulkUpdater(RDFServiceGraph graph) {
        this.graph = graph;
    }

    @Override
    protected void performAddModel(Model model) {
        ChangeSet changeSet = this.graph.getRDFService().manufactureChangeSet();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.write((OutputStream)out, "N-TRIPLE");
        changeSet.addAddition(new ByteArrayInputStream(out.toByteArray()), RDFService.ModelSerializationFormat.N3, this.graph.getGraphURI());
        try {
            this.graph.getRDFService().changeSetUpdate(changeSet);
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    @Override
    protected void performRemoveModel(Model model) {
        ChangeSet changeSet = this.graph.getRDFService().manufactureChangeSet();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        model.write((OutputStream)out, "N-TRIPLE");
        changeSet.addRemoval(new ByteArrayInputStream(out.toByteArray()), RDFService.ModelSerializationFormat.N3, this.graph.getGraphURI());
        try {
            this.graph.getRDFService().changeSetUpdate(changeSet);
        }
        catch (RDFServiceException rdfse) {
            throw new RuntimeException(rdfse);
        }
    }

    @Override
    protected void performRemoveAll() {
        String graphURI = this.graph.getGraphURI();
        String findPattern = "?s ?p ?o";
        StringBuffer findQuery = new StringBuffer("CONSTRUCT { ").append(findPattern).append(" } WHERE { \n");
        if (graphURI != null) {
            findQuery.append("  GRAPH <" + graphURI + "> { ");
        }
        findQuery.append(findPattern);
        if (graphURI != null) {
            findQuery.append(" } ");
        }
        findQuery.append("\n}");
        String queryString = findQuery.toString();
        int chunkSize = 50000;
        boolean done = false;
        while (!done) {
            String chunkQueryString = queryString + " LIMIT " + chunkSize;
            try {
                Model chunkToRemove = RDFServiceUtils.parseModel(this.graph.getRDFService().sparqlConstructQuery(chunkQueryString, RDFService.ModelSerializationFormat.N3), RDFService.ModelSerializationFormat.N3);
                if (chunkToRemove.size() > 0L) {
                    ChangeSet cs = this.graph.getRDFService().manufactureChangeSet();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    chunkToRemove.write((OutputStream)out, "N-TRIPLE");
                    cs.addRemoval(new ByteArrayInputStream(out.toByteArray()), RDFService.ModelSerializationFormat.N3, graphURI);
                    this.graph.getRDFService().changeSetUpdate(cs);
                    continue;
                }
                done = true;
            }
            catch (RDFServiceException e) {
                throw new RuntimeException(e);
            }
        }
        this.graph.getEventManager().notifyEvent((Graph)this.graph, (Object)GraphEvents.removeAll);
    }
}

