/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.search.controller;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.VitroAjaxController;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResultDocumentList;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class AutocompleteController
extends VitroAjaxController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AutocompleteController.class);
    private static final String PARAM_QUERY = "term";
    private static final String PARAM_RDFTYPE = "type";
    private static final String PARAM_MULTIPLE_RDFTYPE = "multipleTypes";
    private boolean hasMultipleTypes = false;
    String NORESULT_MSG = "";
    private static final int DEFAULT_MAX_HIT_COUNT = 1000;
    public static final int MAX_QUERY_LENGTH = 500;

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.USE_BASIC_AJAX_CONTROLLERS.ACTION;
    }

    @Override
    protected void doRequest(VitroRequest vreq, HttpServletResponse response) throws IOException, ServletException {
        try {
            String qtxt = vreq.getParameter(PARAM_QUERY);
            String typeParam = vreq.getParameter(PARAM_RDFTYPE);
            if (typeParam != null) {
                String[] parts = typeParam.split(",");
                if (parts.length > 1) {
                    this.hasMultipleTypes = true;
                } else if (parts.length == 1) {
                    String askQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nASK { ?something rdfs:subClassOf <" + typeParam.replace(",", "") + "> }";
                    if (this.getRdfService((HttpServletRequest)vreq).sparqlAskQuery(askQuery)) {
                        this.hasMultipleTypes = true;
                    }
                }
            } else {
                this.hasMultipleTypes = true;
            }
            SearchQuery query = this.getQuery(qtxt, vreq);
            if (query == null) {
                log.debug((Object)("query for '" + qtxt + "' is null."));
                this.doNoQuery(response);
                return;
            }
            log.debug((Object)("query for '" + qtxt + "' is " + query.toString()));
            SearchEngine search = ApplicationUtils.instance().getSearchEngine();
            SearchResponse queryResponse = search.query(query);
            if (queryResponse == null) {
                log.error((Object)"Query response for a search was null");
                this.doNoSearchResults(response);
                return;
            }
            SearchResultDocumentList docs = queryResponse.getResults();
            if (docs == null) {
                log.error((Object)"Docs for a search was null");
                this.doNoSearchResults(response);
                return;
            }
            long hitCount = docs.getNumFound();
            log.debug((Object)("Total number of hits = " + hitCount));
            if (hitCount < 1L) {
                this.doNoSearchResults(response);
                return;
            }
            ArrayList<SearchResult> results = new ArrayList<SearchResult>();
            for (SearchResultDocument doc : docs) {
                try {
                    String uri = doc.getStringValue("URI");
                    String name = doc.getStringValue("nameRaw");
                    String mst = doc.getStringValue("mostSpecificTypeURIs");
                    Collection<Object> mstObjValues = doc.getFieldValues("mostSpecificTypeURIs");
                    String[] mstStringValues = mstObjValues.toArray(new String[mstObjValues.size()]);
                    List<String> mstValues = Arrays.asList(mstStringValues);
                    SearchResult result = new SearchResult(name, uri, mst, mstValues, this.hasMultipleTypes, vreq);
                    results.add(result);
                    log.debug((Object)("results = " + ((Object)results).toString()));
                }
                catch (Exception e) {
                    log.error((Object)("problem getting usable individuals from search hits" + e.getMessage()));
                }
            }
            this.hasMultipleTypes = false;
            Collections.sort(results);
            JSONArray jsonArray = new JSONArray();
            for (SearchResult result : results) {
                jsonArray.put(result.toJSONObject());
            }
            response.getWriter().write(jsonArray.toString());
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            this.doSearchError(response);
        }
    }

    private SearchQuery getQuery(String queryStr, VitroRequest vreq) {
        if (queryStr == null) {
            log.error((Object)"There was no parameter 'term' in the request.");
            return null;
        }
        if (queryStr.length() > 500) {
            log.debug((Object)"The search was too long. The maximum query length is 500");
            return null;
        }
        SearchQuery query = ApplicationUtils.instance().getSearchEngine().createQuery();
        query.setStart(0).setRows(1000);
        this.setNameQuery(query, queryStr, (HttpServletRequest)vreq);
        String typeParam = vreq.getParameter(PARAM_RDFTYPE);
        String multipleTypesParam = vreq.getParameter(PARAM_MULTIPLE_RDFTYPE);
        if (typeParam != null) {
            this.addFilterQuery(query, typeParam, multipleTypesParam);
        }
        query.addFields("nameRaw", "URI", "mostSpecificTypeURIs");
        return query;
    }

    private void addFilterQuery(SearchQuery query, String typeParam, String multipleTypesParam) {
        if (multipleTypesParam == null || multipleTypesParam.equals("null") || multipleTypesParam.isEmpty()) {
            query.addFilterQuery("type:\"" + typeParam + "\"");
        } else {
            String[] typeParams = typeParam.split(",");
            int len = typeParams.length;
            ArrayList<String> filterQueries = new ArrayList<String>();
            for (int i = 0; i < len; ++i) {
                filterQueries.add("type:\"" + typeParams[i] + "\" ");
            }
            String filterQuery = StringUtils.join(filterQueries, (String)" OR ");
            query.addFilterQuery(filterQuery);
        }
    }

    private void setNameQuery(SearchQuery query, String queryStr, HttpServletRequest request) {
        String tokenizeParam;
        boolean tokenize;
        if (StringUtils.isBlank((CharSequence)queryStr)) {
            log.error((Object)"No query string");
        }
        if (tokenize = "true".equals(tokenizeParam = request.getParameter("tokenize"))) {
            this.setTokenizedNameQuery(query, queryStr, request);
        } else {
            this.setUntokenizedNameQuery(query, queryStr);
        }
    }

    private void setTokenizedNameQuery(SearchQuery query, String queryStr, HttpServletRequest request) {
        String acQueryStr;
        String acTermName = "acNameStemmed";
        String nonAcTermName = "nameStemmed";
        if (queryStr.endsWith(" ")) {
            acQueryStr = this.makeTermQuery(nonAcTermName, queryStr, true);
        } else {
            String lastWord;
            int indexOfLastWord = queryStr.lastIndexOf(" ") + 1;
            ArrayList<String> terms = new ArrayList<String>(2);
            String allButLastWord = queryStr.substring(0, indexOfLastWord);
            if (StringUtils.isNotBlank((CharSequence)allButLastWord)) {
                terms.add(this.makeTermQuery(nonAcTermName, allButLastWord, true));
            }
            if (StringUtils.isNotBlank((CharSequence)(lastWord = queryStr.substring(indexOfLastWord)))) {
                terms.add(this.makeTermQuery(acTermName, lastWord, false));
            }
            acQueryStr = StringUtils.join(terms, (String)" AND ");
        }
        log.debug((Object)("Tokenized name query string = " + acQueryStr));
        query.setQuery(acQueryStr);
    }

    private void setUntokenizedNameQuery(SearchQuery query, String queryStr) {
        queryStr = queryStr.trim();
        queryStr = this.makeTermQuery("acNameUntokenized", queryStr, true);
        query.setQuery(queryStr);
    }

    private String makeTermQuery(String term, String queryStr, boolean mayContainWhitespace) {
        if (mayContainWhitespace) {
            queryStr = "\"" + this.escapeWhitespaceInQueryString(queryStr) + "\"";
        }
        return term + ":" + queryStr;
    }

    private String escapeWhitespaceInQueryString(String queryStr) {
        return queryStr.replaceAll("\\s+", "\\\\ ");
    }

    private void doNoQuery(HttpServletResponse response) throws IOException {
        this.doNoSearchResults(response);
    }

    private void doSearchError(HttpServletResponse response) throws IOException {
        this.doNoSearchResults(response);
    }

    private void doNoSearchResults(HttpServletResponse response) throws IOException {
        response.getWriter().write("[]");
    }

    private RDFService getRdfService(HttpServletRequest req) {
        return RDFServiceUtils.getRDFService(new VitroRequest(req));
    }

    public class SearchResult
    implements Comparable<Object> {
        private String label;
        private String uri;
        private String msType;
        private List<String> allMsTypes;
        private boolean hasMultipleTypes;

        SearchResult(String label, String uri, String msType, List<String> allMsTypes, boolean hasMultipleTypes, VitroRequest vreq) {
            this.label = hasMultipleTypes ? label + " (" + this.getMsTypeLocalName(msType, vreq) + ")" : label;
            this.uri = uri;
            this.msType = msType;
            this.allMsTypes = allMsTypes;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUri() {
            return this.uri;
        }

        public String getMsType() {
            return this.msType;
        }

        public List<String> getAllMsTypes() {
            return this.allMsTypes;
        }

        public String getMsTypeLocalName(String theUri, VitroRequest vreq) {
            VClassDao vcDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getVClassDao();
            VClass vClass = vcDao.getVClassByURI(theUri);
            String theType = vClass.getName() == null ? "" : vClass.getName();
            return theType;
        }

        JSONObject toJSONObject() {
            JSONObject jsonObj = new JSONObject();
            try {
                jsonObj.put("label", this.label);
                jsonObj.put("uri", this.uri);
                jsonObj.put("msType", this.msType);
                JSONArray allMsTypesArray = new JSONArray(this.allMsTypes);
                jsonObj.put("allMsTypes", allMsTypesArray);
            }
            catch (Exception ex) {
                log.error((Object)"Error occurred in converting values to JSON object", (Throwable)ex);
            }
            return jsonObj;
        }

        @Override
        public int compareTo(Object o) throws ClassCastException {
            if (!(o instanceof SearchResult)) {
                throw new ClassCastException("Error in SearchResult.compareTo(): expected SearchResult object.");
            }
            SearchResult sr = (SearchResult)o;
            return this.label.compareToIgnoreCase(sr.getLabel());
        }
    }
}

