/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.solr;

import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchFacetField;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputField;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchFacetField;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchResponse;
import edu.cornell.mannlib.vitro.webapp.searchengine.solr.SolrSearchResultDocumentList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;

public class SolrConversionUtils {
    static List<SolrInputDocument> convertToSolrInputDocuments(Collection<SearchInputDocument> docs) {
        ArrayList<SolrInputDocument> solrDocs = new ArrayList<SolrInputDocument>();
        for (SearchInputDocument doc : docs) {
            solrDocs.add(SolrConversionUtils.convertToSolrInputDocument(doc));
        }
        return solrDocs;
    }

    private static SolrInputDocument convertToSolrInputDocument(SearchInputDocument doc) {
        SolrInputDocument solrDoc = new SolrInputDocument(SolrConversionUtils.convertToSolrInputFieldMap(doc.getFieldMap()));
        solrDoc.setDocumentBoost(doc.getDocumentBoost());
        return solrDoc;
    }

    private static Map<String, SolrInputField> convertToSolrInputFieldMap(Map<String, SearchInputField> fieldMap) {
        HashMap<String, SolrInputField> solrFieldMap = new HashMap<String, SolrInputField>();
        for (String fieldName : fieldMap.keySet()) {
            solrFieldMap.put(fieldName, SolrConversionUtils.convertToSolrInputField(fieldMap.get(fieldName)));
        }
        return solrFieldMap;
    }

    private static SolrInputField convertToSolrInputField(SearchInputField searchInputField) {
        String name = searchInputField.getName();
        SolrInputField solrField = new SolrInputField(name);
        Collection<Object> values = name.equals("ALLTEXT") || name.equals("ALLTEXTUNSTEMMED") ? SolrConversionUtils.joinStringValues(searchInputField.getValues()) : searchInputField.getValues();
        if (!values.isEmpty()) {
            if (values.size() == 1) {
                solrField.addValue(values.iterator().next(), searchInputField.getBoost());
            } else {
                solrField.addValue(values, searchInputField.getBoost());
            }
        }
        return solrField;
    }

    private static Collection<Object> joinStringValues(Collection<Object> values) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<Object> betterValues = new ArrayList<Object>();
        for (Object value : values) {
            if (value instanceof String) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append((String)value);
                continue;
            }
            betterValues.add(value);
        }
        if (buffer.length() > 0) {
            betterValues.add(buffer.toString());
        }
        return betterValues;
    }

    static SolrQuery convertToSolrQuery(SearchQuery query) {
        int minCount;
        SolrQuery solrQuery = new SolrQuery(query.getQuery());
        solrQuery.setStart(Integer.valueOf(query.getStart()));
        int rows = query.getRows();
        if (rows >= 0) {
            solrQuery.setRows(Integer.valueOf(rows));
        }
        for (String string : query.getFieldsToReturn()) {
            solrQuery.addField(string);
        }
        Map<String, SearchQuery.Order> sortFields = query.getSortFields();
        for (String sortField : sortFields.keySet()) {
            solrQuery.addSortField(sortField, SolrConversionUtils.convertToSolrOrder(sortFields.get(sortField)));
        }
        for (String filter : query.getFilters()) {
            solrQuery.addFilterQuery(new String[]{filter});
        }
        if (!query.getFacetFields().isEmpty()) {
            solrQuery.setFacet(true);
        }
        for (String facetField : query.getFacetFields()) {
            solrQuery.addFacetField(new String[]{facetField});
        }
        int n = query.getFacetLimit();
        if (n >= 0) {
            solrQuery.setFacetLimit(n);
        }
        if ((minCount = query.getFacetMinCount()) >= 0) {
            solrQuery.setFacetMinCount(minCount);
        }
        return solrQuery;
    }

    private static SolrQuery.ORDER convertToSolrOrder(SearchQuery.Order order) {
        if (order == SearchQuery.Order.DESC) {
            return SolrQuery.ORDER.desc;
        }
        return SolrQuery.ORDER.asc;
    }

    static SearchResponse convertToSearchResponse(QueryResponse response) {
        return new BaseSearchResponse(response.getHighlighting(), SolrConversionUtils.convertToSearchFacetFieldMap(response.getFacetFields()), new SolrSearchResultDocumentList(response.getResults()));
    }

    private static Map<String, SearchFacetField> convertToSearchFacetFieldMap(List<FacetField> facetFields) {
        HashMap<String, SearchFacetField> map = new HashMap<String, SearchFacetField>();
        if (facetFields != null) {
            for (FacetField facetField : facetFields) {
                map.put(facetField.getName(), SolrConversionUtils.convertToSearchFacetField(facetField));
            }
        }
        return map;
    }

    private static SearchFacetField convertToSearchFacetField(FacetField facetField) {
        return new BaseSearchFacetField(facetField.getName(), SolrConversionUtils.convertToSearchFacetFieldCounts(facetField.getValues()));
    }

    private static List<BaseSearchFacetField.BaseCount> convertToSearchFacetFieldCounts(List<FacetField.Count> solrCounts) {
        ArrayList<BaseSearchFacetField.BaseCount> searchCounts = new ArrayList<BaseSearchFacetField.BaseCount>();
        if (solrCounts != null) {
            for (FacetField.Count solrCount : solrCounts) {
                searchCounts.add(new BaseSearchFacetField.BaseCount(solrCount.getName(), solrCount.getCount()));
            }
        }
        return searchCounts;
    }
}

