/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchengine.solr;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.ComponentStartupStatus;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineNotRespondingException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchResponse;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.searchengine.base.BaseSearchQuery;
import edu.cornell.mannlib.vitro.webapp.searchengine.solr.SolrConversionUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletContext;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;

public class SolrSearchEngine
implements SearchEngine {
    private HttpSolrServer server;

    @Override
    public void startup(Application application, ComponentStartupStatus css) {
        ServletContext ctx = application.getServletContext();
        String solrServerUrlString = ConfigurationProperties.getBean(ctx).getProperty("vitro.local.solr.url");
        if (solrServerUrlString == null) {
            css.fatal("Could not find vitro.local.solr.url in runtime.properties.  Vitro application needs the URL of a solr server that it can use to index its data. It should be something like http://localhost:${port}" + ctx.getContextPath() + "solr");
            return;
        }
        try {
            this.server = new HttpSolrServer(solrServerUrlString);
            this.server.setSoTimeout(10000);
            this.server.setConnectionTimeout(10000);
            this.server.setDefaultMaxConnectionsPerHost(100);
            this.server.setMaxTotalConnections(100);
            this.server.setMaxRetries(1);
            css.info("Set up the Solr search engine; URL = '" + solrServerUrlString + "'.");
        }
        catch (Exception e) {
            css.fatal("Could not set up the Solr search engine", e);
        }
    }

    @Override
    public void shutdown(Application application) {
        this.server.shutdown();
    }

    @Override
    public void ping() throws SearchEngineException {
        try {
            this.server.ping();
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Solr server did not respond to ping.", (Exception)e);
        }
    }

    @Override
    public SearchInputDocument createInputDocument() {
        return new BaseSearchInputDocument();
    }

    @Override
    public void add(SearchInputDocument ... docs) throws SearchEngineException {
        this.add(Arrays.asList(docs));
    }

    @Override
    public void add(Collection<SearchInputDocument> docs) throws SearchEngineException {
        try {
            this.server.add(SolrConversionUtils.convertToSolrInputDocuments(docs));
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Solr server failed to add documents " + docs, (Exception)e);
        }
    }

    @Override
    public void commit() throws SearchEngineException {
        try {
            this.server.commit();
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Failed to commit to Solr server.", (Exception)e);
        }
    }

    @Override
    public void commit(boolean wait) throws SearchEngineException {
        try {
            this.server.commit(wait, wait);
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Failed to commit to Solr server.", (Exception)e);
        }
    }

    @Override
    public void deleteById(String ... ids) throws SearchEngineException {
        this.deleteById(Arrays.asList(ids));
    }

    @Override
    public void deleteById(Collection<String> ids) throws SearchEngineException {
        try {
            this.server.deleteById(new ArrayList<String>(ids));
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Solr server failed to delete documents: " + ids, (Exception)e);
        }
    }

    @Override
    public void deleteByQuery(String query) throws SearchEngineException {
        try {
            this.server.deleteByQuery(query);
        }
        catch (IOException | SolrServerException e) {
            throw this.appropriateException("Solr server failed to delete documents: " + query, (Exception)e);
        }
    }

    @Override
    public SearchQuery createQuery() {
        return new BaseSearchQuery();
    }

    @Override
    public SearchQuery createQuery(String queryText) {
        BaseSearchQuery query = new BaseSearchQuery();
        query.setQuery(queryText);
        return query;
    }

    @Override
    public SearchResponse query(SearchQuery query) throws SearchEngineException {
        try {
            SolrQuery solrQuery = SolrConversionUtils.convertToSolrQuery(query);
            QueryResponse response = this.server.query((SolrParams)solrQuery);
            return SolrConversionUtils.convertToSearchResponse(response);
        }
        catch (SolrServerException e) {
            throw this.appropriateException("Solr server failed to execute the query" + query, (Exception)((Object)e));
        }
    }

    @Override
    public int documentCount() throws SearchEngineException {
        SearchResponse response = this.query(this.createQuery("*:*"));
        return (int)response.getResults().getNumFound();
    }

    private SearchEngineException appropriateException(String message, Exception e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof SocketTimeoutException)) continue;
            return new SearchEngineNotRespondingException(message, e);
        }
        return new SearchEngineException(message, e);
    }
}

