/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.tasks;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineNotRespondingException;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexerStatus;
import edu.cornell.mannlib.vitro.webapp.searchindex.SearchIndexerImpl;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.DocumentModifierList;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.SearchIndexExcluderList;
import edu.cornell.mannlib.vitro.webapp.searchindex.tasks.UpdateUrisTask;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RebuildIndexTask
implements SearchIndexerImpl.Task {
    private static final Log log = LogFactory.getLog(RebuildIndexTask.class);
    private final Date requestedAt;
    private final SearchIndexerImpl.IndexerConfig config;
    private RebuildIndexTaskImpl impl;

    public RebuildIndexTask(SearchIndexerImpl.IndexerConfig config) {
        this.config = config;
        this.requestedAt = new Date();
    }

    @Override
    public void run() {
        this.impl = new RebuildIndexTaskImpl(this.config, this.requestedAt);
        this.impl.run();
    }

    @Override
    public SearchIndexerStatus getStatus() {
        return this.impl == null ? SearchIndexerStatus.idle() : this.impl.getStatus();
    }

    @Override
    public void notifyWorkUnitCompletion(Runnable workUnit) {
        if (this.impl != null) {
            this.impl.notifyWorkUnitCompletion(workUnit);
        }
    }

    public String toString() {
        return "RebuildIndexTask[requestedAt=" + new SimpleDateFormat().format(this.requestedAt) + "]";
    }

    private static class RebuildIndexTaskImpl
    implements SearchIndexerImpl.Task {
        private final SearchIndexerImpl.IndexerConfig config;
        private final IndividualDao indDao;
        private final SearchIndexExcluderList excluders;
        private final DocumentModifierList modifiers;
        private final SearchIndexerImpl.ListenerList listeners;
        private final SearchIndexerImpl.WorkerThreadPool pool;
        private final SearchEngine searchEngine;
        private final Date requestedAt;
        private final int documentsBefore;
        private volatile SearchIndexerStatus status;

        public RebuildIndexTaskImpl(SearchIndexerImpl.IndexerConfig config, Date requestedAt) {
            this.config = config;
            this.excluders = config.excluderList();
            this.modifiers = config.documentModifierList();
            this.indDao = config.individualDao();
            this.listeners = config.listenerList();
            this.pool = config.workerThreadPool();
            this.searchEngine = ApplicationUtils.instance().getSearchEngine();
            this.requestedAt = requestedAt;
            this.documentsBefore = this.getDocumentCount();
            this.status = this.buildStatus(SearchIndexerStatus.State.REBUILDING, 0);
        }

        @Override
        public void run() {
            this.listeners.fireEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.START_REBUILD, this.status));
            Collection<String> uris = this.getAllUrisInTheModel();
            if (!this.isInterrupted()) {
                this.updateTheUris(uris);
                if (!this.isInterrupted()) {
                    this.deleteOutdatedDocuments();
                }
            }
            this.status = this.buildStatus(SearchIndexerStatus.State.REBUILDING, this.getDocumentCount());
            this.listeners.fireEvent(new SearchIndexer.Event(SearchIndexer.Event.Type.STOP_REBUILD, this.status));
        }

        private boolean isInterrupted() {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                return true;
            }
            return false;
        }

        private Collection<String> getAllUrisInTheModel() {
            return this.indDao.getAllIndividualUris();
        }

        private void updateTheUris(Collection<String> uris) {
            UpdateUrisTask.runNow(uris, this.excluders, this.modifiers, this.indDao, this.listeners, this.pool);
        }

        private void deleteOutdatedDocuments() {
            String query = "indexedTime:[ * TO " + this.requestedAt.getTime() + " ]";
            try {
                this.searchEngine.deleteByQuery(query);
                this.searchEngine.commit();
            }
            catch (SearchEngineNotRespondingException e) {
                log.warn((Object)"Failed to delete outdated documents from the search index: the search engine is not responding.");
            }
            catch (SearchEngineException e) {
                log.warn((Object)"Failed to delete outdated documents from the search index", (Throwable)e);
            }
        }

        private int getDocumentCount() {
            try {
                return this.searchEngine.documentCount();
            }
            catch (SearchEngineNotRespondingException e) {
                log.warn((Object)"Failed to get document count from the search index: the search engine is not responding.");
                return 0;
            }
            catch (SearchEngineException e) {
                log.warn((Object)"Failed to get document count from the search index.", (Throwable)e);
                return 0;
            }
        }

        private SearchIndexerStatus buildStatus(SearchIndexerStatus.State state, int documentsAfter) {
            return new SearchIndexerStatus(state, new Date(), new SearchIndexerStatus.RebuildCounts(this.documentsBefore, documentsAfter));
        }

        @Override
        public SearchIndexerStatus getStatus() {
            return this.status;
        }

        @Override
        public void notifyWorkUnitCompletion(Runnable workUnit) {
            log.error((Object)"Why was this called?");
        }

        public String toString() {
            return "RebuildIndexTask[requestedAt=" + new SimpleDateFormat().format(this.requestedAt) + "]";
        }
    }
}

