/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.servlet.setup;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.dao.DisplayVocabulary;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.ontology.update.KnowledgeBaseUpdater;
import edu.cornell.mannlib.vitro.webapp.ontology.update.UpdateSettings;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.ConfigurationModelsSetup;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.JenaDataSourceSetupBase;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.SimpleReasonerSetup;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class UpdateKnowledgeBase {
    public static final String KBM_REQURIED_AT_STARTUP = "KNOWLEDGE_BASE_MIGRATION_REQUIRED_AT_STARTUP";
    private static final Log log = LogFactory.getLog(UpdateKnowledgeBase.class);
    private final String dataDir;
    private final ServletContextListener parent;
    private static final String NEW_DISPLAYMODEL_TBOX_PATH = "/WEB-INF/ontologies/app/menuload/displayTBOX.n3";
    private static final String NEW_DISPLAYMODEL_DISPLAYMETADATA_PATH = "/WEB-INF/ontologies/app/menuload/displayDisplay.n3";
    private static final String NEW_DISPLAYMODEL_PATH = "/WEB-INF/ontologies/app/menu.n3";
    private static final String LOADED_STARTUPT_DISPLAYMODEL_DIR = "/WEB-INF/ontologies/app/loadedAtStartup/";

    public UpdateKnowledgeBase(String dataDir, ServletContextListener parent) {
        this.dataDir = dataDir;
        this.parent = parent;
    }

    private String diffFile() {
        return this.dataDir + "diff.tab.txt";
    }

    private String askQueryFile() {
        return this.dataDir + "askUpdated.sparql";
    }

    private String successAssertionsFile() {
        return this.dataDir + "success.n3";
    }

    private String oldTBoxModelDir() {
        return this.dataDir + "oldVersion/";
    }

    private String oldTBoxAnnotationsDir() {
        return this.dataDir + "oldAnnotations/";
    }

    private String oldDisplayModelTBoxPath() {
        return this.dataDir + "oldDisplayModel/displayTBOX.n3";
    }

    private String oldDisplayModelDisplayMetadataPath() {
        return this.dataDir + "oldDisplayModel/displayDisplay.n3";
    }

    private String oldDisplayModelVivoListViewPath() {
        return this.dataDir + "oldDisplayModel/vivoListViewConfig.rdf";
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        boolean migrationChangesMade = false;
        try {
            UpdateSettings settings = new UpdateSettings();
            this.putReportingPathsIntoSettings(ctx, settings);
            this.putNonReportingPathsIntoSettings(ctx, settings);
            try {
                ApplicationUtils.instance().getTBoxReasonerModule().waitForTBoxReasoning();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WebappDaoFactory wadf = ModelAccess.on(ctx).getWebappDaoFactory();
            settings.setDefaultNamespace(wadf.getDefaultNamespace());
            settings.setAssertionOntModelSelector(ModelAccess.on(ctx).getOntModelSelector(ModelAccess.ReasoningOption.ASSERTIONS_ONLY));
            settings.setInferenceOntModelSelector(ModelAccess.on(ctx).getOntModelSelector(ModelAccess.ReasoningOption.INFERENCES_ONLY));
            settings.setUnionOntModelSelector(ModelAccess.on(ctx).getOntModelSelector());
            Path homeDir = ApplicationUtils.instance().getHomeDirectory().getPath();
            settings.setDisplayModel(ModelAccess.on(ctx).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-displayMetadata"));
            OntModel oldTBoxModel = this.loadModelFromDirectory(ctx.getRealPath(this.oldTBoxModelDir()));
            settings.setOldTBoxModel(oldTBoxModel);
            OntModel newTBoxModel = this.loadModelFromDirectory(this.createDirectory(homeDir, "rdf", "tbox", "filegraph").toString());
            settings.setNewTBoxModel(newTBoxModel);
            OntModel oldTBoxAnnotationsModel = this.loadModelFromDirectory(ctx.getRealPath(this.oldTBoxAnnotationsDir()));
            settings.setOldTBoxAnnotationsModel(oldTBoxAnnotationsModel);
            OntModel newTBoxAnnotationsModel = this.loadModelFromDirectory(this.createDirectory(homeDir, "rdf", "tbox", "firsttime").toString());
            settings.setNewTBoxAnnotationsModel(newTBoxAnnotationsModel);
            settings.setRDFService(ModelAccess.on(ctx).getRDFService());
            boolean tryMigrateDisplay = true;
            try {
                OntModel oldDisplayModelTboxModel = this.loadModelFromFile(ctx.getRealPath(this.oldDisplayModelTBoxPath()));
                settings.setOldDisplayModelTboxModel(oldDisplayModelTboxModel);
                OntModel newDisplayModelTboxModel = this.loadModelFromFile(ctx.getRealPath(NEW_DISPLAYMODEL_TBOX_PATH));
                settings.setNewDisplayModelTboxModel(newDisplayModelTboxModel);
                OntModel oldDisplayModelDisplayMetadataModel = this.loadModelFromFile(ctx.getRealPath(this.oldDisplayModelDisplayMetadataPath()));
                settings.setOldDisplayModelDisplayMetadataModel(oldDisplayModelDisplayMetadataModel);
                OntModel newDisplayModelDisplayMetadataModel = this.loadModelFromFile(ctx.getRealPath(NEW_DISPLAYMODEL_DISPLAYMETADATA_PATH));
                settings.setNewDisplayModelDisplayMetadataModel(newDisplayModelDisplayMetadataModel);
                OntModel newDisplayModelFromFile = this.loadModelFromFile(ctx.getRealPath(NEW_DISPLAYMODEL_PATH));
                settings.setNewDisplayModelFromFile(newDisplayModelFromFile);
                OntModel loadedAtStartupFiles = this.loadModelFromDirectory(ctx.getRealPath(LOADED_STARTUPT_DISPLAYMODEL_DIR));
                settings.setLoadedAtStartupDisplayModel(loadedAtStartupFiles);
                OntModel oldDisplayModelVivoListView = this.loadModelFromFile(ctx.getRealPath(this.oldDisplayModelVivoListViewPath()));
                settings.setVivoListViewConfigDisplayModel(oldDisplayModelVivoListView);
            }
            catch (ModelFileNotFoundException e) {
                tryMigrateDisplay = false;
            }
            catch (Exception e) {
                log.info((Object)"Unable to read display model migration files. ", (Throwable)e);
                tryMigrateDisplay = false;
            }
            KnowledgeBaseUpdater ontologyUpdater = new KnowledgeBaseUpdater(settings);
            boolean requiredUpdate = ontologyUpdater.updateRequired(ctx);
            if (requiredUpdate && !JenaDataSourceSetupBase.isFirstStartup()) {
                try {
                    ctx.setAttribute(KBM_REQURIED_AT_STARTUP, (Object)Boolean.TRUE);
                    migrationChangesMade = ontologyUpdater.update(ctx);
                    if (tryMigrateDisplay) {
                        try {
                            this.migrateDisplayModel(settings);
                            log.info((Object)"Migrated display model");
                        }
                        catch (Exception e) {
                            log.warn((Object)("unable to successfully update display model: " + e.getMessage()));
                        }
                    }
                    new ConfigurationModelsSetup().contextInitialized(sce);
                }
                catch (Exception ioe) {
                    ss.fatal(this.parent, "Exception updating knowledge base for ontology changes: ", ioe);
                }
            }
            this.removeBadRestrictions((Model)settings.getAssertionOntModelSelector().getTBoxModel());
            log.info((Object)"Simple reasoner connected for the ABox");
            if (JenaDataSourceSetupBase.isFirstStartup() || migrationChangesMade && requiredUpdate) {
                SimpleReasonerSetup.setRecomputeRequired(ctx, SimpleReasonerSetup.RecomputeMode.FOREGROUND);
            } else if (migrationChangesMade) {
                SimpleReasonerSetup.setRecomputeRequired(ctx, SimpleReasonerSetup.RecomputeMode.BACKGROUND);
            }
        }
        catch (Throwable t) {
            ss.fatal(this.parent, "Exception updating knowledge base for ontology changes: ", t);
        }
    }

    private void putNonReportingPathsIntoSettings(ServletContext ctx, UpdateSettings settings) {
        settings.setAskUpdatedQueryFile(ctx.getRealPath(this.askQueryFile()));
        settings.setDiffFile(ctx.getRealPath(this.diffFile()));
        settings.setSparqlConstructAdditionsDir(ctx.getRealPath(this.dataDir + "sparqlConstructs/additions"));
        settings.setSparqlConstructDeletionsDir(ctx.getRealPath(this.dataDir + "sparqlConstructs/deletions"));
        settings.setSuccessAssertionsFile(ctx.getRealPath(this.successAssertionsFile()));
        settings.setSuccessRDFFormat("N3");
    }

    private void putReportingPathsIntoSettings(ServletContext ctx, UpdateSettings settings) throws IOException {
        Path homeDir = ApplicationUtils.instance().getHomeDirectory().getPath();
        Path dataDir = this.createDirectory(homeDir, "upgrade", "knowledgeBase");
        settings.setDataDir(dataDir.toString());
        StartupStatus.getBean(ctx).info(this.parent, "Updating knowledge base: reports are in '" + dataDir + "'");
        Path changedDir = this.createDirectory(dataDir, "changedData");
        settings.setAddedDataFile(changedDir.resolve(UpdateKnowledgeBase.timestampedFileName("addedData", "n3")).toString());
        settings.setRemovedDataFile(changedDir.resolve(UpdateKnowledgeBase.timestampedFileName("removedData", "n3")).toString());
        Path logDir = this.createDirectory(dataDir, "logs");
        settings.setLogFile(logDir.resolve(UpdateKnowledgeBase.timestampedFileName("knowledgeBaseUpdate", "log")).toString());
        settings.setErrorLogFile(logDir.resolve(UpdateKnowledgeBase.timestampedFileName("knowledgeBaseUpdate.error", "log")).toString());
        Path qualifiedPropertyConfigFile = this.getFilePath(homeDir, "rdf", "display", "firsttime", "PropertyConfig.n3");
        settings.setQualifiedPropertyConfigFile(qualifiedPropertyConfigFile.toString());
    }

    private Path getFilePath(Path parent, String ... children) throws IOException {
        Path path = parent;
        for (String child : children) {
            path = path.resolve(child);
        }
        return path;
    }

    private Path createDirectory(Path parent, String ... children) throws IOException {
        Path dir = parent;
        for (String child : children) {
            dir = dir.resolve(child);
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateDisplayModel(UpdateSettings settings) throws Exception {
        log.debug((Object)"Beginning migration of display model");
        OntModel displayModel = settings.getDisplayModel();
        Model addStatements = ModelFactory.createDefaultModel();
        Model removeStatements = ModelFactory.createDefaultModel();
        this.replaceTboxAndDisplayMetadata(displayModel, addStatements, removeStatements, settings);
        this.updateDataGetterClassNames(displayModel, addStatements, removeStatements);
        this.addCannotDeleteFlagDisplayModel(displayModel, addStatements, removeStatements);
        this.updatePeoplePageDisplayModel(displayModel, addStatements, removeStatements);
        this.addPageListDisplayModel(displayModel, addStatements, removeStatements, settings);
        this.updateDataGetterLabels(displayModel, addStatements, removeStatements, settings);
        displayModel.enterCriticalSection(false);
        try {
            if (log.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                addStatements.write((Writer)sw, "N3");
                log.debug((Object)"Statements to be added are: ");
                log.debug((Object)sw.toString());
                sw.close();
                sw = new StringWriter();
                removeStatements.write((Writer)sw, "N3");
                log.debug((Object)"Statements to be removed are: ");
                log.debug((Object)sw.toString());
                sw.close();
            }
            displayModel.remove(removeStatements);
            displayModel.add(addStatements);
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    private void replaceTboxAndDisplayMetadata(OntModel displayModel, Model addStatements, Model removeStatements, UpdateSettings settings) {
        OntModel oldDisplayModelTboxModel = settings.getOldDisplayModelTboxModel();
        OntModel oldDisplayModelDisplayMetadataModel = settings.getOldDisplayModelDisplayMetadataModel();
        OntModel newDisplayModelTboxModel = settings.getNewDisplayModelTboxModel();
        OntModel newDisplayModelDisplayMetadataModel = settings.getNewDisplayModelDisplayMetadataModel();
        OntModel loadedAtStartup = settings.getLoadedAtStartupDisplayModel();
        OntModel oldVivoListView = settings.getVivoListViewConfigDisplayModel();
        removeStatements.add((Model)oldDisplayModelTboxModel);
        removeStatements.add((Model)oldDisplayModelDisplayMetadataModel);
        removeStatements.add((Model)oldVivoListView);
        StringWriter sw = new StringWriter();
        try {
            log.debug((Object)"Adding old display tbox model, display metadata model, and oldVivoListView to remove statements.  Remove statements now include:");
            removeStatements.write((Writer)sw, "N3");
            log.debug((Object)sw.toString());
            sw.close();
        }
        catch (Exception ex) {
            log.error((Object)"Exception occurred", (Throwable)ex);
        }
        addStatements.add((Model)newDisplayModelTboxModel);
        addStatements.add((Model)newDisplayModelDisplayMetadataModel);
        addStatements.add((Model)loadedAtStartup);
        try {
            sw = new StringWriter();
            log.debug((Object)"Adding new display tbox model, display metadata model, and loaded at startup to add statements.  Add statements now include:");
            addStatements.write((Writer)sw, "N3");
            log.debug((Object)sw.toString());
            sw.close();
        }
        catch (Exception ex) {
            log.error((Object)"Exception occurred in adding new display model tbox/metadata info to add statements ", (Throwable)ex);
        }
        log.debug((Object)"Adding new display tbox model, display metadata model, and all models loaded at startup");
    }

    private void updateDataGetterClassNames(OntModel displayModel, Model addStatements, Model removeStatements) {
        Resource classGroupOldType = ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.pageDataGetter.ClassGroupPageData");
        Resource browseOldType = ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.pageDataGetter.BrowseDataGetter");
        Resource individualsForClassesOldType = ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.pageDataGetter.IndividualsForClassesDataGetter");
        Resource internalClassesOldType = ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.pageDataGetter.InternalClassesDataGetter");
        Resource classGroupNewType = ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.ClassGroupPageData");
        Resource browseNewType = ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.BrowseDataGetter");
        Resource individualsForClassesNewType = ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.IndividualsForClassesDataGetter");
        Resource internalClassesNewType = ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.InternalClassesDataGetter");
        this.updateAddRemoveDataGetterStatements(displayModel, removeStatements, addStatements, classGroupOldType, classGroupNewType);
        this.updateAddRemoveDataGetterStatements(displayModel, removeStatements, addStatements, browseOldType, browseNewType);
        this.updateAddRemoveDataGetterStatements(displayModel, removeStatements, addStatements, individualsForClassesOldType, individualsForClassesNewType);
        this.updateAddRemoveDataGetterStatements(displayModel, removeStatements, addStatements, internalClassesOldType, internalClassesNewType);
    }

    private void updateAddRemoveDataGetterStatements(OntModel displayModel, Model removeStatements, Model addStatements, Resource oldType, Resource newType) {
        log.debug((Object)("Old type: " + oldType.getURI() + " - newType: " + newType.getURI()));
        removeStatements.add(displayModel.listStatements(null, RDF.type, (RDFNode)oldType));
        StmtIterator oldStatements = displayModel.listStatements(null, RDF.type, (RDFNode)oldType);
        while (oldStatements.hasNext()) {
            Statement stmt = oldStatements.nextStatement();
            addStatements.add(stmt.getSubject(), RDF.type, (RDFNode)newType);
        }
        StringWriter sw = new StringWriter();
        try {
            log.debug((Object)"Adding statements with old data getter types to remove statements, remove statements is now");
            removeStatements.write((Writer)sw, "N3");
            log.debug((Object)sw.toString());
            sw.close();
            sw = new StringWriter();
            log.debug((Object)"Adding statements with new data getter types to add statements, add statements is now");
            addStatements.write((Writer)sw, "N3");
            log.debug((Object)sw.toString());
            sw.close();
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in writing out remove and statements for data getter types", (Throwable)ex);
        }
    }

    private void addCannotDeleteFlagDisplayModel(OntModel displayModel, Model addStatements, Model removeStatements) {
        Resource homePage = displayModel.getResource("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#Home");
        addStatements.add(homePage, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#cannotDeletePage"), (RDFNode)ResourceFactory.createPlainLiteral((String)"true"));
    }

    private void updatePeoplePageDisplayModel(OntModel displayModel, Model addStatements, Model removeStatements) {
        Resource peoplePage = displayModel.getResource("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#People");
        if (peoplePage != null) {
            removeStatements.add(peoplePage, (Property)DisplayVocabulary.REQUIRES_BODY_TEMPLATE, (RDFNode)ResourceFactory.createPlainLiteral((String)"menupage--classgroup-people.ftl"));
        }
        log.debug((Object)"Will remove body template from people page so added that to remove statements ");
    }

    private void addPageListDisplayModel(OntModel displayModel, Model addStatements, Model removeStatements, UpdateSettings settings) {
        OntModel newDisplayModel = settings.getNewDisplayModelFromFile();
        Resource pageList = newDisplayModel.getResource("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#pageListPage");
        Resource pageListData = newDisplayModel.getResource("http://vitro.mannlib.cornell.edu/ontologies/display/1.1#pageListData");
        addStatements.add(newDisplayModel.listStatements(pageList, null, (RDFNode)null));
        addStatements.add(newDisplayModel.listStatements(pageListData, null, (RDFNode)null));
        StringWriter sw = new StringWriter();
        try {
            if (pageList != null) {
                log.debug((Object)("Page list uri is " + pageList.getURI()));
            } else {
                log.debug((Object)"Page list uri is null for some reason");
            }
            log.debug((Object)"New Display model from file is ");
            newDisplayModel.write((Writer)sw, "N3");
            log.debug((Object)sw.toString());
            sw.close();
            sw = new StringWriter();
            log.debug((Object)"Added statements now include ");
            addStatements.write((Writer)sw, "N3");
            log.debug((Object)sw.toString());
            sw.close();
        }
        catch (Exception ex) {
            log.error((Object)"Exception occurred in writing out new display model", (Throwable)ex);
        }
        log.debug((Object)"Checking: AFTER adding pageList resource, what do we have for pageList page");
        Resource testResource = ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#pageListPage");
        StmtIterator testIt = addStatements.listStatements(testResource, null, (RDFNode)null);
        if (!testIt.hasNext()) {
            log.debug((Object)("Add statements does not have the page list page resource " + testResource.getURI()));
        }
        while (testIt.hasNext()) {
            log.debug((Object)("Statement for page list resource: " + testIt.nextStatement().toString()));
        }
    }

    private void updateDataGetterLabels(OntModel displayModel, Model addStatements, Model removeStatements, UpdateSettings settings) {
        log.debug((Object)"Checking: BEFORE adding any statements, what do we have for pageList page");
        Resource testResource = ResourceFactory.createResource((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#pageListPage");
        StmtIterator testIt = addStatements.listStatements(testResource, null, (RDFNode)null);
        if (!testIt.hasNext()) {
            log.debug((Object)("Add statements does not have the page list page resource " + testResource.getURI()));
        }
        while (testIt.hasNext()) {
            log.debug((Object)("Statement for page list resource: " + testIt.nextStatement().toString()));
        }
        log.debug((Object)"Triple checking -- before this method, the add statements model contains");
        StringWriter sw = new StringWriter();
        try {
            addStatements.write((Writer)sw, "N3");
            log.debug((Object)sw.toString());
            sw.close();
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in adding resource labels ", (Throwable)ex);
        }
        OntModel newDisplayModel = settings.getNewDisplayModelFromFile();
        ArrayList<Resource> resourcesForLabels = new ArrayList<Resource>();
        resourcesForLabels.add(ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.ClassGroupPageData"));
        resourcesForLabels.add(ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.BrowseDataGetter"));
        resourcesForLabels.add(ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.IndividualsForClassesDataGetter"));
        resourcesForLabels.add(ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.InternalClassesDataGetter"));
        resourcesForLabels.add(ResourceFactory.createResource((String)"java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.SparqlQueryDataGetter"));
        for (Resource r : resourcesForLabels) {
            log.debug((Object)("Adding the following for " + r.getURI()));
            log.debug((Object)newDisplayModel.listStatements(r, RDFS.label, (RDFNode)null).toList().toString());
            addStatements.add(newDisplayModel.listStatements(r, RDFS.label, (RDFNode)null));
            log.debug((Object)"After adding statements, we now have the following in addStatements:::");
            sw = new StringWriter();
            try {
                addStatements.write((Writer)sw, "N3");
                log.debug((Object)sw.toString());
                sw.close();
            }
            catch (Exception ex) {
                log.error((Object)"Error occurred in adding resource labels ", (Throwable)ex);
            }
        }
        log.debug((Object)"AFTER all resources added, Add statements now includes ");
        sw = new StringWriter();
        try {
            addStatements.write((Writer)sw, "N3");
            log.debug((Object)sw.toString());
            sw.close();
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in adding resource labels ", (Throwable)ex);
        }
    }

    private OntModel loadModelFromDirectory(String directoryPath) {
        log.debug((Object)("Loading model from directory " + directoryPath));
        OntModel om = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        File directory = new File(directoryPath);
        if (!directory.isDirectory()) {
            throw new ModelDirectoryNotFoundException(directoryPath + " must be a directory " + "containing RDF files.");
        }
        File[] rdfFiles = directory.listFiles();
        for (int i = 0; i < rdfFiles.length; ++i) {
            this.readFile(rdfFiles[i], om, directoryPath);
        }
        return om;
    }

    private OntModel loadModelFromFile(String filePath) {
        log.debug((Object)("Load model from file " + filePath));
        OntModel om = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        File file = new File(filePath);
        if (!file.isFile()) {
            throw new ModelFileNotFoundException(filePath + " must be a file " + "containing RDF files.");
        }
        this.readFile(file, om, filePath);
        return om;
    }

    private void readFile(File f, OntModel om, String path) {
        block5: {
            try {
                FileInputStream fis = new FileInputStream(f);
                try {
                    if (f.getName().endsWith(".md")) break block5;
                    if (f.getName().endsWith(".n3")) {
                        om.read((InputStream)fis, null, "N3");
                        break block5;
                    }
                    om.read((InputStream)fis, null, "RDF/XML");
                }
                catch (Exception e) {
                    log.error((Object)("Unable to load RDF from " + f.getName()), (Throwable)e);
                }
            }
            catch (FileNotFoundException fnfe) {
                log.error((Object)(f.getName() + " not found. Unable to load" + " RDF from this location: " + path));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBadRestrictions(Model tboxModel) {
        List<String> queryStrs = Arrays.asList("PREFIX owl:   <http://www.w3.org/2002/07/owl#> \n CONSTRUCT { \n    ?rest ?p ?o . \n    ?oo ?pp ?rest \n} WHERE { \n    ?rest a owl:Restriction . \n    FILTER NOT EXISTS { ?rest owl:onProperty ?x } \n    ?rest ?p ?o . \n    ?oo ?pp ?rest \n} \n", "PREFIX owl:   <http://www.w3.org/2002/07/owl#> \n CONSTRUCT { \n    ?rest ?p ?o . \n    ?oo ?pp ?rest \n} WHERE { \n    ?rest a owl:Restriction . \n    { ?rest owl:someValuesFrom ?c } UNION { ?rest owl:allValuesFrom ?c } \n    FILTER (regex(str(?c), \"vivoweb.org\")) \n    FILTER NOT EXISTS { ?c ?cp ?co } \n    ?rest ?p ?o . \n    ?oo ?pp ?rest \n} \n");
        for (String queryStr : queryStrs) {
            Query query = QueryFactory.create((String)queryStr);
            QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)tboxModel);
            try {
                Model bad = qe.execConstruct();
                tboxModel.remove(bad);
                if (bad.size() <= 0L) continue;
                log.info((Object)("Deleted " + bad.size() + " triples of syntactically invalid restrictions"));
            }
            finally {
                if (qe == null) continue;
                qe.close();
            }
        }
    }

    private static String timestampedFileName(String prefix, String suffix) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-sss");
        return prefix + "." + sdf.format(new Date()) + "." + suffix;
    }

    private class ModelFileNotFoundException
    extends RuntimeException {
        public ModelFileNotFoundException(String msg) {
            super(msg);
        }
    }

    private class ModelDirectoryNotFoundException
    extends RuntimeException {
        public ModelDirectoryNotFoundException(String msg) {
            super(msg);
        }
    }
}

