/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.sparql;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetAllClasses
extends BaseEditController {
    private static final Log log = LogFactory.getLog(GetAllClasses.class);

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_MISCELLANEOUS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        List<VClassGroup> classGroups = vreq.getUnfilteredWebappDaoFactory().getVClassGroupDao().getPublicGroupsWithVClasses(true, true, false);
        Iterator<VClassGroup> classGroupIt = classGroups.iterator();
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        String respo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        respo = respo + "<options>";
        while (classGroupIt.hasNext()) {
            VClassGroup group = classGroupIt.next();
            List<VClass> classes = group.getVitroClassList();
            for (VClass clazz : classes) {
                respo = respo + "<option><key>" + clazz.getPickListName() + "</key>" + "<value>" + clazz.getURI() + "</value>" + "</option>";
            }
        }
        respo = respo + "</options>";
        out.println(respo);
        out.flush();
        out.close();
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

