/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.triplesource.impl.sdb;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import java.beans.PropertyVetoException;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SDBDataSource {
    private static final Log log = LogFactory.getLog(SDBDataSource.class);
    private final ConfigurationProperties configProps;

    public SDBDataSource(ServletContext ctx) {
        this.configProps = ConfigurationProperties.getBean(ctx);
    }

    public ComboPooledDataSource getDataSource() {
        try {
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            cpds.setDriverClass(this.getDbDriverClassName());
            cpds.setJdbcUrl(this.getJdbcUrl());
            cpds.setUser(this.configProps.getProperty("VitroConnection.DataSource.username"));
            cpds.setPassword(this.configProps.getProperty("VitroConnection.DataSource.password"));
            cpds.setMaxPoolSize(this.getMaxActive());
            cpds.setMinPoolSize(this.getMaxIdle());
            cpds.setMaxIdleTime(this.getMaxIdleTime());
            cpds.setMaxIdleTimeExcessConnections(this.getMaxIdleTimeExcess());
            cpds.setAcquireIncrement(5);
            cpds.setNumHelperThreads(6);
            cpds.setTestConnectionOnCheckout(true);
            cpds.setTestConnectionOnCheckin(true);
            cpds.setPreferredTestQuery(this.getValidationQuery());
            return cpds;
        }
        catch (PropertyVetoException pve) {
            throw new RuntimeException(pve);
        }
    }

    private String getDbDriverClassName() {
        return this.configProps.getProperty("VitroConnection.DataSource.driver", "com.mysql.jdbc.Driver");
    }

    private String getDbType() {
        return this.configProps.getProperty("VitroConnection.DataSource.dbtype", "MySQL");
    }

    private String getJdbcUrl() {
        String url = this.configProps.getProperty("VitroConnection.DataSource.url");
        if ("MySQL".equals(this.getDbType()) && !url.contains("?")) {
            url = url + "?useUnicode=yes&characterEncoding=utf8";
        }
        return url;
    }

    private String getValidationQuery() {
        return this.configProps.getProperty("VitroConnection.DataSource.validationQuery", "SELECT 1");
    }

    private int getMaxActive() {
        String maxActiveStr = this.configProps.getProperty("VitroConnection.DataSource.pool.maxActive");
        if (StringUtils.isEmpty((CharSequence)maxActiveStr)) {
            return 40;
        }
        int maxActive = 40;
        try {
            maxActive = Integer.parseInt(maxActiveStr);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Unable to parse connection pool maxActive setting " + maxActiveStr + " as an integer"));
            return 40;
        }
        if (maxActive >= 20) {
            return maxActive;
        }
        log.warn((Object)"Specified value for VitroConnection.DataSource.pool.maxActive is too low. Using minimum value of 20");
        return 20;
    }

    private int getMaxIdle() {
        int maxIdleInt = Math.max(this.getMaxActive() / 4, 10);
        return this.getPropertyAsInt("VitroConnection.DataSource.pool.maxIdle", maxIdleInt);
    }

    private int getMaxIdleTime() {
        return this.getPropertyAsInt("VitroConnection.DataSource.pool.maxIdleTime", 1800);
    }

    private int getMaxIdleTimeExcess() {
        return this.getPropertyAsInt("VitroConnection.DataSource.pool.maxIdleTimeExcess", 300);
    }

    private int getPropertyAsInt(String prop, int defaultValue) {
        String propStr = this.configProps.getProperty(prop);
        if (StringUtils.isEmpty((CharSequence)propStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propStr);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Unable to parse connection pool maxIdle setting " + propStr + " as an integer"));
            return defaultValue;
        }
    }
}

