/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDFS;

public class ApplicationConfigurationOntologyUtils {
    private static final Log log = LogFactory.getLog(ApplicationConfigurationOntologyUtils.class);

    public static List<ObjectProperty> getAdditionalFauxSubpropertiesForList(List<ObjectProperty> propList, Individual subject, VitroRequest vreq) {
        OntModel displayModel = vreq.getDisplayModel();
        OntModel tboxModel = vreq.getOntModelSelector().getTBoxModel();
        return ApplicationConfigurationOntologyUtils.getAdditionalFauxSubpropertiesForList(propList, subject, (Model)displayModel, (Model)tboxModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ObjectProperty> getAdditionalFauxSubproperties(ObjectProperty prop, Individual subject, Model tboxModel, Model union) {
        ArrayList<ObjectProperty> additionalProps = new ArrayList<ObjectProperty>();
        String queryStr = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX config: <http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationConfiguration#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT DISTINCT ?range ?domain ?property WHERE { \n    ?context config:configContextFor ?property . \n    ?context config:qualifiedBy ?range . \n    ?context config:hasConfiguration ?configuration . \n    ?configuration a config:ObjectPropertyDisplayConfig . \n    OPTIONAL { ?context config:qualifiedByDomain ?domain } \n}";
        if (prop != null) {
            log.debug((Object)("Checking " + prop.getURI() + " for additional properties"));
            queryStr = queryStr.replaceAll("For \\?property", "For <" + prop.getURI() + ">");
        }
        log.debug((Object)queryStr);
        Query q = QueryFactory.create((String)queryStr);
        QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)union);
        WebappDaoFactoryJena wadf = new WebappDaoFactoryJena(ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)union));
        ObjectPropertyDao opDao = wadf.getObjectPropertyDao();
        try {
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution qsoln = rs.nextSolution();
                log.debug((Object)qsoln);
                String opURI = prop != null ? prop.getURI() : qsoln.getResource("property").getURI();
                Resource domainRes = qsoln.getResource("domain");
                String domainURI = domainRes != null ? domainRes.getURI() : null;
                String rangeURI = qsoln.getResource("range").getURI();
                if (!ApplicationConfigurationOntologyUtils.appropriateDomain(domainRes, subject, tboxModel)) continue;
                ObjectProperty faux = opDao.getObjectPropertyByURIs(opURI, domainURI, rangeURI, prop != null ? prop.clone() : null);
                if (faux != null) {
                    additionalProps.add(faux);
                    continue;
                }
                log.error((Object)("Could not retrieve " + opURI + " qualified by " + " domain " + domainURI + " and range " + rangeURI));
            }
        }
        finally {
            qe.close();
        }
        return additionalProps;
    }

    public static List<ObjectProperty> getAdditionalFauxSubpropertiesForList(List<ObjectProperty> propList, Individual subject, Model displayModel, Model tboxModel) {
        ArrayList<ObjectProperty> additionalProps = new ArrayList<ObjectProperty>();
        Model union = ModelFactory.createUnion((Model)displayModel, (Model)tboxModel);
        for (ObjectProperty op : propList) {
            additionalProps.addAll(ApplicationConfigurationOntologyUtils.getAdditionalFauxSubproperties(op, subject, tboxModel, union));
        }
        return additionalProps;
    }

    private static boolean appropriateDomain(Resource domainRes, Individual subject, Model tboxModel) {
        if (subject == null || domainRes == null) {
            return true;
        }
        for (VClass vclass : subject.getVClasses()) {
            if (vclass.getURI() == null || !vclass.getURI().equals(domainRes.getURI()) && !tboxModel.contains(ResourceFactory.createResource((String)vclass.getURI()), RDFS.subClassOf, (RDFNode)domainRes)) continue;
            return true;
        }
        return false;
    }
}

