/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.TemplateProcessingHelper;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class JSPPageHandler {
    public static void renderBasicPage(HttpServletRequest req, HttpServletResponse res, String bodyJsp) throws ServletException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jspBody", JSPPageHandler.renderToString(req, res, bodyJsp));
        if (req.getAttribute("scripts") instanceof String) {
            map.put("jspScripts", JSPPageHandler.renderToString(req, res, (String)req.getAttribute("scripts")));
        }
        if (req.getAttribute("title") instanceof String) {
            map.put("title", req.getAttribute("title"));
        }
        TemplateResponseValues values = new TemplateResponseValues("jspTransition.ftl", map);
        new FreemarkerWrapper().wrap(req, res, values);
    }

    private static String renderToString(HttpServletRequest req, HttpServletResponse res, String jsp) throws ServletException, IOException {
        StringBufferResponse customResponse = new StringBufferResponse(res);
        RequestDispatcher rd = req.getRequestDispatcher(jsp);
        rd.include((ServletRequest)req, (ServletResponse)customResponse);
        return customResponse.getOutput();
    }

    public static void renderPlainInclude(HttpServletRequest req, HttpServletResponse res, String pageJsp) throws ServletException, IOException {
        RequestDispatcher rd = req.getRequestDispatcher(pageJsp);
        rd.include((ServletRequest)req, (ServletResponse)res);
    }

    public static void renderPlainPage(HttpServletRequest req, HttpServletResponse res, String pageJsp) throws ServletException, IOException {
        RequestDispatcher rd = req.getRequestDispatcher(pageJsp);
        rd.forward((ServletRequest)req, (ServletResponse)res);
    }

    private static class FreemarkerWrapper
    extends FreemarkerHttpServlet {
        private FreemarkerWrapper() {
        }

        public void wrap(HttpServletRequest req, HttpServletResponse res, ResponseValues values) {
            try {
                this.doTemplate(new VitroRequest(req), res, values);
            }
            catch (TemplateProcessingHelper.TemplateProcessingException templateProcessingException) {
                // empty catch block
            }
        }
    }

    private static class StringBufferResponse
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        private final CharArrayWriter charArray = new CharArrayWriter();

        public StringBufferResponse(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new ServletOutputStream(){

                public void write(int b) throws IOException {
                    byteArray.write(b);
                }
            };
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(this.charArray);
        }

        public String getOutput() {
            if (this.charArray.size() > 0) {
                return this.charArray.toString();
            }
            if (this.byteArray.size() > 0) {
                try {
                    return new String(this.byteArray.toByteArray(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return "";
        }
    }
}

