/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterBase;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.VClassGroupTemplateModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.json.JSONObject;

public class ClassGroupPageData
extends DataGetterBase
implements DataGetter {
    private static final Log log = LogFactory.getLog(ClassGroupPageData.class);
    String dataGetterURI;
    String classGroupUri;
    VitroRequest vreq;
    ServletContext context;
    private static final String forClassGroupURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup>";
    private static final String dataGetterQuery = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?classGroupUri WHERE { \n  ?dataGetterUri <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup> ?classGroupUri . \n}";

    public ClassGroupPageData(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        this.configure(vreq, displayModel, dataGetterURI);
    }

    protected void configure(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        if (vreq == null) {
            throw new IllegalArgumentException("VitroRequest  may not be null.");
        }
        if (displayModel == null) {
            throw new IllegalArgumentException("Display Model may not be null.");
        }
        if (dataGetterURI == null) {
            throw new IllegalArgumentException("PageUri may not be null.");
        }
        this.vreq = vreq;
        this.context = vreq.getSession().getServletContext();
        this.dataGetterURI = dataGetterURI;
        this.classGroupUri = DataGetterUtils.getClassGroupForDataGetter(displayModel, dataGetterURI);
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> pageData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("classGroupUri", this.classGroupUri);
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)this.vreq);
        List<VClassGroup> vcgList = vcgc.getGroups();
        VClassGroup group = null;
        for (VClassGroup vClassGroup : vcgList) {
            if (vClassGroup.getURI() == null || !vClassGroup.getURI().equals(this.classGroupUri)) continue;
            group = vClassGroup;
            break;
        }
        if (this.classGroupUri != null && !this.classGroupUri.isEmpty() && group == null) {
            group = this.vreq.getWebappDaoFactory().getVClassGroupDao().getGroupByURI(this.classGroupUri);
            if (group != null) {
                List<VClassGroup> vcgFullList = this.vreq.getWebappDaoFactory().getVClassGroupDao().getPublicGroupsWithVClasses(false, true, false);
                for (VClassGroup vcg : vcgFullList) {
                    if (!this.classGroupUri.equals(vcg.getURI())) continue;
                    group = vcg;
                    break;
                }
                ClassGroupPageData.setAllClassCountsToZero(group);
                log.debug((Object)("Retrieved class group " + group.getURI() + " and returning to template"));
                if (log.isDebugEnabled()) {
                    List<VClass> list = group.getVitroClassList();
                    for (VClass v : list) {
                        log.debug((Object)("Class " + v.getName() + " - " + v.getURI() + " has " + v.getEntityCount() + " entities"));
                    }
                }
            } else {
                throw new RuntimeException("classgroup " + this.classGroupUri + " does not exist in the system");
            }
        }
        data.put("vClassGroup", group);
        data.put("bodyTemplate", "page-classgroup.ftl");
        data.put("dataServiceUrlIndividualsByVClass", this.getDataServiceUrl());
        return data;
    }

    public static VClassGroupTemplateModel getClassGroup(String classGroupUri, ServletContext context, VitroRequest vreq) {
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)vreq);
        List<VClassGroup> vcgList = vcgc.getGroups();
        VClassGroup group = null;
        for (VClassGroup vcg : vcgList) {
            if (vcg.getURI() == null || !vcg.getURI().equals(classGroupUri)) continue;
            group = vcg;
            break;
        }
        if (classGroupUri != null && !classGroupUri.isEmpty() && group == null) {
            group = vreq.getWebappDaoFactory().getVClassGroupDao().getGroupByURI(classGroupUri);
            if (group != null) {
                List<VClassGroup> vcgFullList = vreq.getWebappDaoFactory().getVClassGroupDao().getPublicGroupsWithVClasses(false, true, false);
                for (VClassGroup vcg : vcgFullList) {
                    if (!classGroupUri.equals(vcg.getURI())) continue;
                    group = vcg;
                    break;
                }
                if (group == null) {
                    log.error((Object)("Cannot get classgroup '" + classGroupUri + "'"));
                    return null;
                }
                ClassGroupPageData.setAllClassCountsToZero(group);
            } else {
                log.error((Object)("classgroup " + classGroupUri + " does not exist in the system"));
                return null;
            }
        }
        return new VClassGroupTemplateModel(group);
    }

    public String getDataServiceUrl() {
        return UrlBuilder.getUrl("/dataservice?getRenderedSearchIndividualsByVClass=1&vclassId=");
    }

    public JSONObject convertToJSON(Map<String, Object> dataMap, VitroRequest vreq) {
        JSONObject rObj = null;
        return rObj;
    }

    protected static void setAllClassCountsToZero(VClassGroup vcg) {
        for (VClass vc : vcg) {
            vc.setEntityCount(0);
        }
    }
}

