/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.json.JSONObject;

public class DataGetterUtils {
    static final Log log = LogFactory.getLog(DataGetterUtils.class);
    public static final String DATA_GETTERS_FOR_PAGE = "data_getters_for_page";
    static final String prefixes = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n";
    private static final String forClassGroupURI = "<http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup>";
    private static final String classGroupForDataGetterQuery = "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?classGroupUri WHERE { \n  ?dataGetterURI <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup> ?classGroupUri . \n}";

    public static List<DataGetter> getDataGettersForPage(VitroRequest vreq, Model displayModel, String pageURI) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException {
        if (vreq.getAttribute(DATA_GETTERS_FOR_PAGE) != null) {
            return (List)vreq.getAttribute(DATA_GETTERS_FOR_PAGE);
        }
        List<String> dgUris = DataGetterUtils.getDataGetterURIsForAssociatedURI(displayModel, pageURI);
        List<DataGetter> dgList = DataGetterUtils.dataGettersForURIs(vreq, displayModel, dgUris);
        log.debug((Object)("getDataGettersForPage: " + dgList));
        vreq.setAttribute(DATA_GETTERS_FOR_PAGE, dgList);
        return dgList;
    }

    public static List<DataGetter> getDataGettersForClass(VitroRequest vreq, Model displayModel, String classURI) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException {
        List<String> dgUris = DataGetterUtils.getDataGetterURIsForAssociatedURI(displayModel, classURI);
        List<DataGetter> dgList = DataGetterUtils.dataGettersForURIs(vreq, displayModel, dgUris);
        log.debug((Object)("getDataGettersForClass: " + dgList));
        return dgList;
    }

    public static List<DataGetter> getDataGettersForTemplate(VitroRequest vreq, Model displayModel, String templateName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException {
        String templateUri = "freemarker:" + templateName;
        List<String> dgUris = DataGetterUtils.getDataGetterURIsForAssociatedURI(displayModel, templateUri);
        List<DataGetter> dgList = DataGetterUtils.dataGettersForURIs(vreq, displayModel, dgUris);
        log.debug((Object)("getDataGettersForTemplate '" + templateName + "': " + dgList));
        return dgList;
    }

    private static List<DataGetter> dataGettersForURIs(VitroRequest vreq, Model displayModel, List<String> dgUris) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException {
        ArrayList<DataGetter> dgList = new ArrayList<DataGetter>();
        for (String dgURI : dgUris) {
            DataGetter dg = DataGetterUtils.dataGetterForURI(vreq, displayModel, dgURI);
            if (dg == null) continue;
            dgList.add(dg);
        }
        return dgList;
    }

    public static DataGetter dataGetterForURI(VitroRequest vreq, Model displayModel, String dataGetterURI) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, SecurityException {
        Object[][] argLists;
        String dgClassName = DataGetterUtils.getJClassForDataGetterURI(displayModel, dataGetterURI);
        Class<?> clz = Class.forName(dgClassName);
        if (!DataGetter.class.isAssignableFrom(clz)) {
            log.debug((Object)("Class doesn't implement DataGetter: '" + dgClassName + "'"));
            return null;
        }
        for (Object[] argList : argLists = new Object[][]{{vreq, displayModel, dataGetterURI}, {displayModel, dataGetterURI}, {vreq}, new Object[0]}) {
            for (Constructor<?> ct : clz.getConstructors()) {
                if (!DataGetterUtils.isConstructorSuitableForArguments(ct, argList)) continue;
                log.debug((Object)("Using this constructor: " + ct));
                return (DataGetter)ct.newInstance(argList);
            }
        }
        log.debug((Object)("Didn't find a suitable constructor for '" + dgClassName + "'"));
        return null;
    }

    private static boolean isConstructorSuitableForArguments(Constructor<?> ct, Object[] args) {
        Class<?>[] parameterTypes = ct.getParameterTypes();
        if (args.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            Class<?> argClass = args[i].getClass();
            if (parameterTypes[i].isAssignableFrom(argClass)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJClassForDataGetterURI(Model displayModel, String dataGetterURI) throws IllegalAccessException {
        String query = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?type WHERE { ?dgURI rdf:type ?type } ";
        Query dgTypeQuery = QueryFactory.create((String)query);
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("dgURI", (RDFNode)ResourceFactory.createResource((String)dataGetterURI));
        ArrayList<String> types = new ArrayList<String>();
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)dgTypeQuery, (Model)displayModel, (QuerySolution)initialBindings);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                Resource type = soln.getResource("type");
                if (type == null || type.getURI() == null) continue;
                types.add(DataGetterUtils.getClassNameFromUri(type.getURI()));
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        return DataGetterUtils.chooseType(types, dataGetterURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getDataGetterURIsForAssociatedURI(Model displayModel, String associatedURI) {
        String query = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nSELECT ?dataGetter WHERE { ?associatedURI display:hasDataGetter ?dataGetter }";
        Query dgForUriQuery = QueryFactory.create((String)query);
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("associatedURI", (RDFNode)ResourceFactory.createResource((String)associatedURI));
        ArrayList<String> dgURIs = new ArrayList<String>();
        displayModel.enterCriticalSection(false);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)dgForUriQuery, (Model)displayModel, (QuerySolution)initialBindings);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                Resource dg = soln.getResource("dataGetter");
                if (dg == null || dg.getURI() == null) continue;
                dgURIs.add(dg.getURI());
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        log.debug((Object)("Found " + dgURIs.size() + " DataGetter URIs for '" + associatedURI + "': " + dgURIs));
        return dgURIs;
    }

    private static String chooseType(List<String> types, String dataGetterURI) throws IllegalAccessException {
        for (String type : types) {
            if (StringUtils.isEmpty((CharSequence)type) || type.equals(OWL.Thing.getURI())) continue;
            return type;
        }
        throw new IllegalAccessException("No useful type defined for <" + dataGetterURI + ">");
    }

    protected static String nodeToString(RDFNode node) {
        if (node == null) {
            return "";
        }
        if (node.isLiteral()) {
            Literal literal = node.asLiteral();
            return literal.getLexicalForm();
        }
        if (node.isURIResource()) {
            Resource resource = node.asResource();
            return resource.getURI();
        }
        if (node.isAnon()) {
            Resource resource = node.asResource();
            return resource.getId().getLabelString();
        }
        return "";
    }

    public static String generateDataGetterTypeURI(String dataGetterClassName) {
        return "java:" + dataGetterClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getClassGroupForDataGetter(Model displayModel, String dataGetterURI) {
        String classGroupUri = null;
        QuerySolutionMap initBindings = new QuerySolutionMap();
        initBindings.add("dataGetterURI", (RDFNode)ResourceFactory.createResource((String)dataGetterURI));
        int count = 0;
        Query dataGetterConfigurationQuery = QueryFactory.create((String)classGroupForDataGetterQuery);
        displayModel.enterCriticalSection(true);
        try {
            QueryExecution qexec = QueryExecutionFactory.create((Query)dataGetterConfigurationQuery, (Model)displayModel, (QuerySolution)initBindings);
            ResultSet res = qexec.execSelect();
            try {
                while (res.hasNext()) {
                    ++count;
                    QuerySolution soln = res.next();
                    Resource node = soln.getResource("classGroupUri");
                    if (node != null && node.isURIResource()) {
                        classGroupUri = node.asResource().getURI();
                        continue;
                    }
                    classGroupUri = null;
                }
            }
            finally {
                qexec.close();
            }
        }
        finally {
            displayModel.leaveCriticalSection();
        }
        return classGroupUri;
    }

    public static JSONObject covertDataToJSONForPage(VitroRequest vreq, String pageUri, Model displayModel) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        JSONObject rObj = null;
        try {
            List<DataGetter> dataGetters = DataGetterUtils.getDataGettersForPage(vreq, displayModel, pageUri);
            for (DataGetter getter : dataGetters) {
                Object var7_8 = null;
            }
        }
        catch (Throwable th) {
            log.error((Object)th, th);
        }
        return rObj;
    }

    public static String getClassNameFromUri(String dataGetterClassUri) {
        String[] splitArray;
        if (!StringUtils.isEmpty((CharSequence)dataGetterClassUri) && dataGetterClassUri.contains("java:") && (splitArray = dataGetterClassUri.split("java:")).length > 1) {
            return splitArray[1];
        }
        return dataGetterClassUri;
    }

    public static JSONObject processVClassGroupJSON(VClassGroup vcg) {
        JSONObject map = new JSONObject();
        try {
            ArrayList<JSONObject> classes = new ArrayList<JSONObject>(vcg.size());
            for (VClass vc : vcg) {
                JSONObject vcObj = new JSONObject();
                vcObj.put("name", vc.getName());
                vcObj.put("URI", vc.getURI());
                vcObj.put("entityCount", vc.getEntityCount());
                classes.add(vcObj);
            }
            map.put("classes", classes);
            map.put("classGroupName", vcg.getPublicName());
            map.put("classGroupUri", vcg.getURI());
        }
        catch (Exception ex) {
            log.error((Object)"Error occurred in processing VClass group ", (Throwable)ex);
        }
        return map;
    }

    public static List<HashMap<String, String>> getClassGroups(HttpServletRequest req) {
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups(req);
        List<VClassGroup> vcgList = vcgc.getGroups();
        ArrayList<HashMap<String, String>> classGroups = new ArrayList<HashMap<String, String>>();
        for (VClassGroup vcg : vcgList) {
            HashMap<String, String> hs = new HashMap<String, String>();
            hs.put("publicName", vcg.getPublicName());
            hs.put("URI", vcg.getURI());
            classGroups.add(hs);
        }
        return classGroups;
    }

    public static void getClassGroupForDataGetter(HttpServletRequest req, Map<String, Object> pageData, Map<String, Object> templateData) {
        String classGroupUri = (String)pageData.get("classGroupUri");
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups(req);
        VClassGroup group = vcgc.getGroup(classGroupUri);
        templateData.put("classGroup", group);
        templateData.put("associatedPage", group.getPublicName());
        templateData.put("associatedPageURI", group.getURI());
    }
}

