/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterBase;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchQueryUtils;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.VClassGroupTemplateModel;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.json.JSONObject;

public class IndividualsForClassesDataGetter
extends DataGetterBase
implements DataGetter {
    private static final Log log = LogFactory.getLog(IndividualsForClassesDataGetter.class);
    protected static String restrictClassesTemplateName = null;
    VitroRequest vreq;
    ServletContext context;
    String dataGetterURI;
    String classGroupURI;
    Map<String, Object> classIntersectionsMap;
    private static final String defaultTemplate = "page-classgroup.ftl";
    private static final String prefixes = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n";
    private static final String dataGetterQuery = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT ?class ?restrictClass WHERE {\n ?dataGetterUri <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass> ?class . \n    OPTIONAL {?dg <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByClass> ?restrictClass } .\n} \n";

    public IndividualsForClassesDataGetter(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        this.configure(vreq, displayModel, dataGetterURI);
    }

    protected void configure(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        if (vreq == null) {
            throw new IllegalArgumentException("VitroRequest  may not be null.");
        }
        if (displayModel == null) {
            throw new IllegalArgumentException("Display Model may not be null.");
        }
        if (dataGetterURI == null) {
            throw new IllegalArgumentException("PageUri may not be null.");
        }
        this.vreq = vreq;
        this.context = vreq.getSession().getServletContext();
        this.dataGetterURI = dataGetterURI;
        this.classGroupURI = DataGetterUtils.getClassGroupForDataGetter(displayModel, dataGetterURI);
        this.classIntersectionsMap = this.getClassIntersectionsMap(displayModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getClassIntersectionsMap(Model displayModel) {
        QuerySolutionMap initBindings = new QuerySolutionMap();
        initBindings.add("dataGetterUri", (RDFNode)ResourceFactory.createResource((String)this.dataGetterURI));
        try {
            HashMap<String, Object> hashMap;
            QueryExecution qexec = QueryExecutionFactory.create((String)dataGetterQuery, (Model)displayModel, (QuerySolution)initBindings);
            HashMap<String, Object> classesAndRestrictions = new HashMap<String, Object>();
            ArrayList<String> classes = new ArrayList<String>();
            displayModel.enterCriticalSection(true);
            try {
                ArrayList<String> restrictClasses = new ArrayList<String>();
                HashMap<String, String> restrictClassesPresentMap = new HashMap<String, String>();
                ResultSet resultSet = qexec.execSelect();
                while (resultSet.hasNext()) {
                    QuerySolution soln = resultSet.next();
                    classes.add(DataGetterUtils.nodeToString(soln.get("class")));
                    String restrictClass = DataGetterUtils.nodeToString(soln.get("restrictClass"));
                    if (restrictClass.isEmpty() || restrictClassesPresentMap.containsKey(restrictClass)) continue;
                    restrictClasses.add(restrictClass);
                    restrictClassesPresentMap.put(restrictClass, "true");
                }
                if (classes.size() == 0) {
                    log.debug((Object)("No classes  defined in display model for " + this.dataGetterURI));
                    this.classIntersectionsMap = null;
                }
                classesAndRestrictions.put("classes", classes);
                classesAndRestrictions.put("restrictClasses", restrictClasses);
                hashMap = classesAndRestrictions;
            }
            catch (Throwable throwable) {
                qexec.close();
                throw throwable;
            }
            qexec.close();
            return hashMap;
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> pageData) {
        this.setTemplateName();
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            List<String> classes = this.retrieveClasses(this.context, this.classIntersectionsMap);
            List<String> restrictClasses = this.retrieveRestrictClasses(this.context, this.classIntersectionsMap);
            log.debug((Object)("Retrieving classes for " + classes.toString() + " and restricting by " + restrictClasses.toString()));
            this.processClassesAndRestrictions(this.vreq, this.context, data, classes, restrictClasses);
            data.put("dataServiceUrlIndividualsByVClass", this.getDataServiceUrl());
            data.put("classGroupUri", this.classGroupURI);
            data.put("bodyTemplate", defaultTemplate);
        }
        catch (Exception ex) {
            log.error((Object)"An error occurred retrieving Vclass Intersection individuals", (Throwable)ex);
        }
        return data;
    }

    protected void setTemplateName() {
        restrictClassesTemplateName = "restricted";
    }

    protected List<String> retrieveClasses(ServletContext context, Map<String, Object> classIntersectionsMap) {
        List restrictClasses = (List)classIntersectionsMap.get("classes");
        return restrictClasses;
    }

    protected List<String> retrieveRestrictClasses(ServletContext context, Map<String, Object> classIntersectionsMap) {
        List restrictClasses = (List)classIntersectionsMap.get("restrictClasses");
        return restrictClasses;
    }

    protected void processClassesAndRestrictions(VitroRequest vreq, ServletContext context, HashMap<String, Object> data, List<String> classes, List<String> restrictClasses) {
        this.processClassesForDisplay(vreq, context, data, classes);
        this.processRestrictionClasses(vreq, data, restrictClasses);
        this.processIntersections(vreq, context, data);
    }

    private void processIntersections(VitroRequest vreq, ServletContext context, HashMap<String, Object> data) {
        VClassGroup classesGroup = (VClassGroup)data.get("vClassGroup");
        List<VClass> vclassList = classesGroup.getVitroClassList();
        List restrictClasses = (List)data.get("restrictVClasses");
        if (restrictClasses.size() > 0) {
            log.debug((Object)"Restriction classes exist");
            ArrayList<VClass> newVClassList = new ArrayList<VClass>();
            for (VClass v : vclassList) {
                int oldCount = v.getEntityCount();
                VClass copyVClass = this.makeCopyVClass(v);
                int count = this.retrieveCount(vreq, context, v, restrictClasses);
                if (oldCount != count) {
                    log.debug((Object)("Old count was " + v.getEntityCount() + " and New count for " + v.getURI() + " is " + count));
                    copyVClass.setEntityCount(count);
                }
                newVClassList.add(copyVClass);
            }
            classesGroup.setVitroClassList(newVClassList);
            data.put("vClassGroup", classesGroup);
        }
    }

    private VClass makeCopyVClass(VClass v) {
        VClass copyVClass = new VClass(v.getURI());
        copyVClass.setLocalName(copyVClass.getLocalName());
        copyVClass.setDisplayRank(v.getDisplayRank());
        copyVClass.setName(v.getName());
        copyVClass.setNamespace(v.getNamespace());
        copyVClass.setEntityCount(v.getEntityCount());
        return copyVClass;
    }

    private int retrieveCount(VitroRequest vreq, ServletContext context, VClass v, List<VClass> restrictClasses) {
        log.debug((Object)("Entity count is " + v.getEntityCount()));
        ArrayList<String> classUris = new ArrayList<String>();
        classUris.add(v.getURI());
        for (VClass r : restrictClasses) {
            classUris.add(r.getURI());
        }
        long count = SearchQueryUtils.getIndividualCount(classUris);
        return new Long(count).intValue();
    }

    private void processClassesForDisplay(VitroRequest vreq, ServletContext context, HashMap<String, Object> data, List<String> classes) {
        VClassGroup classesGroup = new VClassGroup();
        classesGroup.setURI("displayClasses");
        log.debug((Object)"Processing classes that will be displayed");
        ArrayList<VClass> vClasses = new ArrayList<VClass>();
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)vreq);
        for (String classUri : classes) {
            VClass vclass = vcgc.getCachedVClass(classUri);
            if (vclass == null) {
                vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(classUri);
            }
            if (vclass != null) {
                log.debug((Object)("VClass does exist for " + classUri + " and entity count is " + vclass.getEntityCount()));
                vClasses.add(vclass);
                continue;
            }
            log.debug((Object)("Vclass " + classUri + " does not exist in the cache"));
            log.error((Object)("Error occurred, vclass does not exist for this uri " + classUri));
        }
        Collections.sort(vClasses);
        log.debug((Object)"Sorting complete for V Classes");
        classesGroup.setVitroClassList(vClasses);
        log.debug((Object)"Returning vitro class list in data for template");
        data.put("vClassGroup", classesGroup);
    }

    private void processRestrictionClasses(VitroRequest vreq, HashMap<String, Object> data, List<String> restrictClasses) {
        try {
            VClassGroup restrictClassesGroup = new VClassGroup();
            restrictClassesGroup.setURI("restrictClasses");
            ArrayList<VClass> restrictVClasses = new ArrayList<VClass>();
            ArrayList<String> urlEncodedRestrictClasses = new ArrayList<String>();
            VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)vreq);
            if (restrictClasses.size() > 0) {
                for (String restrictClassUri : restrictClasses) {
                    VClass vclass = vcgc.getCachedVClass(restrictClassUri);
                    if (vclass == null) {
                        vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(restrictClassUri);
                    }
                    if (vclass != null) {
                        log.debug((Object)("Found restrict class and adding to list " + restrictClassUri));
                        restrictVClasses.add(vclass);
                    } else {
                        log.error((Object)("Error occurred, vclass does not exist for this uri " + restrictClassUri));
                    }
                    urlEncodedRestrictClasses.add(URLEncoder.encode(restrictClassUri, "UTF-8"));
                }
                restrictClassesGroup.setVitroClassList(restrictVClasses);
                restrictClassesGroup.setIndividualCount(restrictVClasses.size());
            }
            Object[] restrictClassesArray = new String[urlEncodedRestrictClasses.size()];
            restrictClassesArray = urlEncodedRestrictClasses.toArray(restrictClassesArray);
            log.debug((Object)("Variable name for including restriction classes " + IndividualsForClassesDataGetter.getRestrictClassesTemplateName()));
            data.put(IndividualsForClassesDataGetter.getRestrictClassesTemplateName(), StringUtils.join((Object[])restrictClassesArray, (String)","));
            data.put("restrictVClasses", restrictVClasses);
            data.put("restrictVClassGroup", restrictClassesGroup);
        }
        catch (Exception ex) {
            log.error((Object)"An error occurred in processing restriction classes ", (Throwable)ex);
        }
    }

    public static VClassGroupTemplateModel getClassGroup(String classGroupUri, VitroRequest vreq) {
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)vreq);
        List<VClassGroup> vcgList = vcgc.getGroups();
        VClassGroup group = null;
        for (VClassGroup vcg : vcgList) {
            if (vcg.getURI() == null || !vcg.getURI().equals(classGroupUri)) continue;
            group = vcg;
            break;
        }
        if (classGroupUri != null && !classGroupUri.isEmpty() && group == null) {
            group = vreq.getWebappDaoFactory().getVClassGroupDao().getGroupByURI(classGroupUri);
            if (group != null) {
                List<VClassGroup> vcgFullList = vreq.getWebappDaoFactory().getVClassGroupDao().getPublicGroupsWithVClasses(false, true, false);
                for (VClassGroup vcg : vcgFullList) {
                    if (!classGroupUri.equals(vcg.getURI())) continue;
                    group = vcg;
                    break;
                }
                if (group == null) {
                    log.error((Object)("Cannot get classgroup '" + classGroupUri + "'"));
                    return null;
                }
                IndividualsForClassesDataGetter.setAllClassCountsToZero(group);
            } else {
                log.error((Object)("classgroup " + classGroupUri + " does not exist in the system"));
                return null;
            }
        }
        return new VClassGroupTemplateModel(group);
    }

    public String getType() {
        return DataGetterUtils.generateDataGetterTypeURI(IndividualsForClassesDataGetter.class.getName());
    }

    public String getDataServiceUrl() {
        return UrlBuilder.getUrl("/dataservice?getRenderedSearchIndividualsByVClass=1&vclassId=");
    }

    public JSONObject convertToJSON(Map<String, Object> dataMap, VitroRequest vreq) {
        JSONObject rObj = null;
        return rObj;
    }

    protected static void setAllClassCountsToZero(VClassGroup vcg) {
        for (VClass vc : vcg) {
            vc.setEntityCount(0);
        }
    }

    protected static String getAlphaParameter(VitroRequest request) {
        return request.getParameter("alpha");
    }

    protected static int getPageParameter(VitroRequest request) {
        String pageStr = request.getParameter("page");
        if (pageStr != null) {
            try {
                return Integer.parseInt(pageStr);
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)"could not parse page parameter");
                return 1;
            }
        }
        return 1;
    }

    private static String getRestrictClassesTemplateName() {
        return restrictClassesTemplateName;
    }
}

