/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;

public abstract class ResultSetParser<T> {
    protected abstract T parseResults(String var1, ResultSet var2);

    protected abstract T defaultValue();

    protected String ifResourcePresent(QuerySolution solution, String variableName, String defaultValue) {
        RDFNode node = solution.get(variableName);
        if (node == null || !node.isURIResource()) {
            return defaultValue;
        }
        return node.asResource().getURI();
    }

    protected String ifLiteralPresent(QuerySolution solution, String variableName, String defaultValue) {
        Literal literal = solution.getLiteral(variableName);
        if (literal == null) {
            return defaultValue;
        }
        return literal.getString();
    }

    protected long ifLongPresent(QuerySolution solution, String variableName, long defaultValue) {
        Literal literal = solution.getLiteral(variableName);
        if (literal == null) {
            return defaultValue;
        }
        return literal.getLong();
    }

    protected int ifIntPresent(QuerySolution solution, String variableName, int defaultValue) {
        Literal literal = solution.getLiteral(variableName);
        if (literal == null) {
            return defaultValue;
        }
        return literal.getInt();
    }
}

