/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;

public class StringResultsMapping {
    public static final StringResultsMapping EMPTY = new StringResultsMapping();
    private final List<Map<String, String>> listOfMaps;

    public StringResultsMapping() {
        this.listOfMaps = Collections.emptyList();
    }

    public StringResultsMapping(ResultSet results, Set<String> fieldNames) {
        this.listOfMaps = this.mapResultsForQuery(results, fieldNames);
    }

    private List<Map<String, String>> mapResultsForQuery(ResultSet results, Set<String> fieldNames) {
        ArrayList<Map<String, String>> mapping = new ArrayList<Map<String, String>>();
        while (results.hasNext()) {
            Map<String, String> rowMapping = this.mapResultsForRow(results.nextSolution(), fieldNames);
            if (rowMapping.isEmpty()) continue;
            mapping.add(rowMapping);
        }
        return mapping;
    }

    private Map<String, String> mapResultsForRow(QuerySolution row, Set<String> fieldNames) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator names = row.varNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            RDFNode node = row.get(name);
            String text = this.getTextForNode(node);
            if (!StringUtils.isNotBlank((String)text)) continue;
            map.put(name, text);
        }
        if (!fieldNames.isEmpty()) {
            map.keySet().retainAll(fieldNames);
        }
        return map;
    }

    private String getTextForNode(RDFNode node) {
        if (node == null) {
            return "";
        }
        if (node.isLiteral()) {
            return node.asLiteral().getString().trim();
        }
        return node.toString().trim();
    }

    public List<Map<String, String>> getListOfMaps() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Map<String, String> map : this.listOfMaps) {
            list.add(new HashMap<String, String>(map));
        }
        return list;
    }

    public List<String> flatten() {
        ArrayList<String> flat = new ArrayList<String>();
        for (Map<String, String> map : this.listOfMaps) {
            flat.addAll(map.values());
        }
        return flat;
    }

    public Set<String> flattenToSet() {
        return new HashSet<String>(this.flatten());
    }
}

