/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.jsptags;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionsForPropertyTag
extends TagSupport {
    private static final Log log = LogFactory.getLog((String)OptionsForPropertyTag.class.getName());
    private String subjectUri;
    private String predicateUri;
    private String selectedUri;

    public String getSubjectUri() {
        return this.subjectUri;
    }

    public void setSubjectUri(String subjectUri) {
        this.subjectUri = subjectUri;
    }

    public String getPredicateUri() {
        return this.predicateUri;
    }

    public void setPredicateUri(String predicateUri) {
        this.predicateUri = predicateUri;
    }

    public String getSelectedUri() {
        return this.selectedUri;
    }

    public void setSelectedUri(String selectedUri) {
        this.selectedUri = selectedUri;
    }

    public int doStartTag() {
        try {
            VitroRequest vreq = new VitroRequest((HttpServletRequest)this.pageContext.getRequest());
            WebappDaoFactory wdf = vreq.getWebappDaoFactory();
            if (wdf == null) {
                throw new Exception("could not get WebappDaoFactory from request.");
            }
            Individual subject = wdf.getIndividualDao().getIndividualByURI(this.getSubjectUri());
            if (subject == null) {
                throw new Exception("could not get individual for subject uri " + this.getSubjectUri());
            }
            ObjectProperty objProp = wdf.getObjectPropertyDao().getObjectPropertyByURI(this.getPredicateUri());
            if (objProp == null) {
                throw new Exception("could not get object property for predicate " + this.getPredicateUri());
            }
            List<Object> vclasses = new ArrayList();
            vclasses = wdf.getVClassDao().getVClassesForProperty(this.getPredicateUri(), true);
            HashMap<String, Individual> indMap = new HashMap<String, Individual>();
            for (VClass vClass : vclasses) {
                for (Individual ind : wdf.getIndividualDao().getIndividualsByVClassURI(vClass.getURI(), -1, -1)) {
                    if (indMap.containsKey(ind.getURI())) continue;
                    indMap.put(ind.getURI(), ind);
                }
            }
            List<Individual> individuals = new ArrayList<Individual>(indMap.values());
            List<ObjectPropertyStatement> list = subject.getObjectPropertyStatements();
            if (list == null) {
                throw new Exception("object properties for subject were null");
            }
            individuals = this.removeIndividualsAlreadyInRange(individuals, list);
            Collections.sort(individuals, new compareEnts());
            JspWriter out = this.pageContext.getOut();
            int optionsCount = 0;
            for (Individual ind : individuals) {
                String uri = ind.getURI();
                if (uri == null) continue;
                out.print("<option value=\"" + StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)uri) + '\"');
                if (uri.equals(this.getSelectedUri())) {
                    out.print(" selected=\"selected\"");
                }
                out.print('>');
                out.print(StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)ind.getName()));
                out.println("</option>");
                ++optionsCount;
            }
            log.trace((Object)("added " + optionsCount + " options for object property \"" + this.getPredicateUri() + "\" in OptionsForPropertyTag.doStartTag()"));
        }
        catch (Exception ex) {
            throw new Error("Error in doStartTag: " + ex.getMessage());
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    private List<Individual> removeIndividualsAlreadyInRange(List<Individual> indiviuals, List<ObjectPropertyStatement> stmts) {
        log.trace((Object)"starting to check for duplicate range individuals in OptionsForPropertyTag.removeIndividualsAlreadyInRange() ...");
        HashSet<String> range = new HashSet<String>();
        for (ObjectPropertyStatement ops : stmts) {
            if (!ops.getPropertyURI().equals(this.getPredicateUri())) continue;
            range.add(ops.getObjectURI());
        }
        int removeCount = 0;
        ListIterator<Individual> it = indiviuals.listIterator();
        while (it.hasNext()) {
            Individual ind = it.next();
            if (!range.contains(ind.getURI())) continue;
            it.remove();
            ++removeCount;
        }
        log.trace((Object)("removed " + removeCount + " duplicate range individuals"));
        return indiviuals;
    }

    private class compareEnts
    implements Comparator<Individual> {
        private compareEnts() {
        }

        @Override
        public int compare(Individual o1, Individual o2) {
            return (o1.getName() == null ? "" : o1.getName()).compareToIgnoreCase(o2.getName() == null ? "" : o2.getName());
        }
    }
}

