/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview;

import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.CustomListViewConfigFile;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.CustomListViewLogger;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.InvalidConfigurationException;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.CollatedObjectPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.DefaultObjectPropertyDataPostProcessor;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyDataPostProcessor;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyListConfig {
    private static final Log log = LogFactory.getLog(PropertyListConfig.class);
    private static final String CONFIG_FILE_PATH = "/config/";
    private static final String DEFAULT_CONFIG_FILE_NAME = "listViewConfig-default.xml";
    private final ObjectPropertyTemplateModel optm;
    private final VitroRequest vreq;
    private final TemplateLoader templateLoader;
    private boolean isDefaultConfig;
    private Set<String> constructQueries;
    private String selectQuery;
    private String templateName;
    private ObjectPropertyDataPostProcessor postprocessor;

    public PropertyListConfig(ObjectPropertyTemplateModel optm, TemplateLoader templateLoader, VitroRequest vreq, ObjectProperty op, boolean editing) throws InvalidConfigurationException {
        ObjectPropertyTemplateModel.ConfigError configError;
        this.optm = optm;
        this.vreq = vreq;
        WebappDaoFactory wadf = vreq.getWebappDaoFactory();
        this.templateLoader = templateLoader;
        String configFileName = wadf.getObjectPropertyDao().getCustomListViewConfigFileName(op);
        if (configFileName == null) {
            configFileName = DEFAULT_CONFIG_FILE_NAME;
        } else {
            CustomListViewLogger.log(op, configFileName);
        }
        log.debug((Object)("Using list view config file " + configFileName + " for object property " + op.getURI()));
        String configFilePath = this.getConfigFilePath(configFileName);
        try {
            File config = new File(configFilePath);
            if (!this.isDefaultConfig(configFileName) && !config.exists()) {
                log.warn((Object)("Can't find config file " + configFilePath + " for object property " + op.getURI() + "\n" + ". Using default config file instead."));
                configFilePath = this.getConfigFilePath(DEFAULT_CONFIG_FILE_NAME);
            }
            this.setValuesFromConfigFile(configFilePath, wadf, editing);
        }
        catch (Exception e) {
            log.error((Object)("Error processing config file " + configFilePath + " for object property " + op.getURI()), (Throwable)e);
        }
        if (!this.isDefaultConfig(configFileName) && (configError = this.checkConfiguration()) != null) {
            if (optm instanceof CollatedObjectPropertyTemplateModel) {
                throw new InvalidConfigurationException(configError.getMessage());
            }
            log.warn((Object)("Invalid list view config for object property " + op.getURI() + " in " + configFilePath + ":\n" + (Object)((Object)configError) + " Using default config instead."));
            configFilePath = this.getConfigFilePath(DEFAULT_CONFIG_FILE_NAME);
            this.setValuesFromConfigFile(configFilePath, wadf, editing);
        }
        this.isDefaultConfig = this.isDefaultConfig(configFileName);
    }

    private boolean isDefaultConfig(String configFileName) {
        return configFileName.equals(DEFAULT_CONFIG_FILE_NAME);
    }

    private ObjectPropertyTemplateModel.ConfigError checkConfiguration() {
        ObjectPropertyTemplateModel.ConfigError error = this.optm.checkQuery(this.selectQuery);
        if (error != null) {
            return error;
        }
        if (StringUtils.isBlank((CharSequence)this.selectQuery)) {
            return ObjectPropertyTemplateModel.ConfigError.NO_SELECT_QUERY;
        }
        if (StringUtils.isBlank((CharSequence)this.templateName)) {
            return ObjectPropertyTemplateModel.ConfigError.NO_TEMPLATE;
        }
        try {
            if (this.templateLoader.findTemplateSource(this.templateName) == null) {
                return ObjectPropertyTemplateModel.ConfigError.TEMPLATE_NOT_FOUND;
            }
        }
        catch (IOException e) {
            log.error((Object)("Error finding template " + this.templateName), (Throwable)e);
        }
        return null;
    }

    private void setValuesFromConfigFile(String configFilePath, WebappDaoFactory wdf, boolean editing) {
        try {
            FileReader reader = new FileReader(configFilePath);
            CustomListViewConfigFile configFileContents = new CustomListViewConfigFile(reader);
            boolean collated = this.optm instanceof CollatedObjectPropertyTemplateModel;
            this.selectQuery = configFileContents.getSelectQuery(collated, editing);
            this.templateName = configFileContents.getTemplateName();
            this.constructQueries = configFileContents.getConstructQueries();
            String postprocessorName = configFileContents.getPostprocessorName();
            this.postprocessor = this.getPostProcessor(postprocessorName, this.optm, wdf, configFilePath);
        }
        catch (Exception e) {
            log.error((Object)("Error processing config file " + configFilePath), (Throwable)e);
        }
    }

    private ObjectPropertyDataPostProcessor getPostProcessor(String className, ObjectPropertyTemplateModel optm, WebappDaoFactory wdf, String configFilePath) {
        try {
            if (StringUtils.isBlank((CharSequence)className)) {
                return new DefaultObjectPropertyDataPostProcessor(optm, wdf);
            }
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(ObjectPropertyTemplateModel.class, WebappDaoFactory.class);
            return (ObjectPropertyDataPostProcessor)constructor.newInstance(optm, wdf);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Error processing config file '" + configFilePath + "': can't load postprocessor class '" + className + "'. " + "Using default postprocessor."), (Throwable)e);
            return new DefaultObjectPropertyDataPostProcessor(optm, wdf);
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)("Error processing config file '" + configFilePath + "': postprocessor class '" + className + "' does not have a constructor that takes " + "ObjectPropertyTemplateModel and WebappDaoFactory. " + "Using default postprocessor."), (Throwable)e);
            return new DefaultObjectPropertyDataPostProcessor(optm, wdf);
        }
        catch (ClassCastException e) {
            log.warn((Object)("Error processing config file '" + configFilePath + "': postprocessor class '" + className + "' does " + "not implement ObjectPropertyDataPostProcessor. " + "Using default postprocessor."), (Throwable)e);
            return new DefaultObjectPropertyDataPostProcessor(optm, wdf);
        }
        catch (Exception e) {
            log.warn((Object)("Error processing config file '" + configFilePath + "': can't create postprocessor instance of class '" + className + "'. " + "Using default postprocessor."), (Throwable)e);
            return new DefaultObjectPropertyDataPostProcessor(optm, wdf);
        }
    }

    private String getConfigFilePath(String filename) {
        return this.vreq.getSession().getServletContext().getRealPath(CONFIG_FILE_PATH + filename);
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public Set<String> getConstructQueries() {
        return this.constructQueries;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean isDefaultListView() {
        return this.isDefaultConfig;
    }

    public ObjectPropertyDataPostProcessor getPostprocessor() {
        return this.postprocessor;
    }
}

