/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyDataPostProcessor;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseObjectPropertyDataPostProcessor
implements ObjectPropertyDataPostProcessor {
    private static final Log log = LogFactory.getLog(BaseObjectPropertyDataPostProcessor.class);
    protected final ObjectPropertyTemplateModel objectPropertyTemplateModel;
    protected final WebappDaoFactory wdf;

    public BaseObjectPropertyDataPostProcessor(ObjectPropertyTemplateModel optm, WebappDaoFactory wdf) {
        this.objectPropertyTemplateModel = optm;
        this.wdf = wdf;
    }

    @Override
    public void process(List<Map<String, String>> data) {
        if (data.isEmpty()) {
            log.debug((Object)("No data to postprocess for property " + this.objectPropertyTemplateModel.getUri()));
            return;
        }
        this.processList(data);
        for (Map<String, String> map : data) {
            this.process(map);
        }
    }

    protected void processList(List<Map<String, String>> data) {
        this.objectPropertyTemplateModel.removeDuplicates(data);
    }

    protected abstract void process(Map<String, String> var1);

    protected void addName(Map<String, String> map, String nameKey, String objectKey) {
        Individual ind;
        String name = map.get(nameKey);
        if (name == null && (ind = this.getIndividual(map.get(objectKey))) != null) {
            map.put(nameKey, ind.getName());
        }
    }

    protected Individual getIndividual(String uri) {
        return this.wdf.getIndividualDao().getIndividualByURI(uri);
    }
}

