/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.customlistview.InvalidConfigurationException;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyStatementTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.SubclassTemplateModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollatedObjectPropertyTemplateModel
extends ObjectPropertyTemplateModel {
    private static final Log log = LogFactory.getLog(CollatedObjectPropertyTemplateModel.class);
    private static final String SUBCLASS_VARIABLE_NAME = "subclass";
    private static final Pattern SELECT_SUBCLASS_PATTERN = Pattern.compile("SELECT[^{]*\\?subclass\\b", 2);
    private static final Pattern ORDER_BY_SUBCLASS_PATTERN = Pattern.compile("ORDER\\s+BY\\s+(DESC\\s*\\(\\s*)?\\?subclass", 2);
    private final List<SubclassTemplateModel> subclasses;
    private final VClassDao vclassDao;

    CollatedObjectPropertyTemplateModel(ObjectProperty op, Individual subject, VitroRequest vreq, boolean editing, List<ObjectProperty> populatedObjectPropertyList) throws InvalidConfigurationException {
        super(op, subject, vreq, editing);
        this.vclassDao = vreq.getWebappDaoFactory().getVClassDao();
        if (populatedObjectPropertyList.contains(op)) {
            log.debug((Object)("Getting data for populated object property " + op.getURI()));
            List<Map<String, String>> statementData = this.getStatementData();
            this.postprocess(statementData);
            log.debug((Object)("Collate:collating subclasses for " + this.subjectUri + " - predicate= " + op.getURI()));
            this.subclasses = this.collate(this.subjectUri, op, statementData, editing);
            for (SubclassTemplateModel subclass : this.subclasses) {
                List<ObjectPropertyStatementTemplateModel> list = subclass.getStatements();
                this.postprocessStatementList(list);
            }
            Collections.sort(this.subclasses);
        } else {
            log.debug((Object)("Object property " + this.getUri() + " is unpopulated."));
            this.subclasses = new ArrayList<SubclassTemplateModel>();
        }
    }

    @Override
    protected boolean isEmpty() {
        return this.subclasses.isEmpty();
    }

    @Override
    public ObjectPropertyTemplateModel.ConfigError checkQuery(String queryString) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return ObjectPropertyTemplateModel.ConfigError.NO_SELECT_QUERY;
        }
        Matcher m = SELECT_SUBCLASS_PATTERN.matcher(queryString);
        if (!m.find()) {
            return ObjectPropertyTemplateModel.ConfigError.NO_SUBCLASS_SELECT;
        }
        m = ORDER_BY_SUBCLASS_PATTERN.matcher(queryString);
        if (!m.find()) {
            return ObjectPropertyTemplateModel.ConfigError.NO_SUBCLASS_ORDER_BY;
        }
        return null;
    }

    @Override
    protected void removeDuplicates(List<Map<String, String>> data) {
        this.filterSubclasses(data);
        super.removeDuplicates(data);
    }

    private void filterSubclasses(List<Map<String, String>> statementData) {
        String objectVariableName = this.getObjectKey();
        if (objectVariableName == null) {
            log.error((Object)("Cannot remove duplicate statements for property " + this.getUri() + " because no object found to dedupe."));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Data before subclass filtering");
            this.logData(statementData);
        }
        ArrayList<Map<String, String>> filteredList = new ArrayList<Map<String, String>>();
        HashSet<String> processedObjects = new HashSet<String>();
        for (int outerIndex = 0; outerIndex < statementData.size(); ++outerIndex) {
            Map<String, String> outerMap = statementData.get(outerIndex);
            String objectUri = outerMap.get(objectVariableName);
            if (processedObjects.contains(objectUri)) continue;
            processedObjects.add(objectUri);
            if (outerIndex == statementData.size() - 1) {
                filteredList.add(outerMap);
                continue;
            }
            ArrayList<Map<String, String>> dataForThisObject = new ArrayList<Map<String, String>>();
            dataForThisObject.add(outerMap);
            for (int innerIndex = outerIndex + 1; innerIndex < statementData.size(); ++innerIndex) {
                Map<String, String> innerMap = statementData.get(innerIndex);
                if (!innerMap.get(objectVariableName).equals(objectUri)) continue;
                dataForThisObject.add(innerMap);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Object URI " + objectUri + " has number of statements = " + dataForThisObject.size()));
            }
            if (dataForThisObject.size() == 1) {
                filteredList.add(outerMap);
                continue;
            }
            Collections.sort(dataForThisObject, new DataComparatorBySubclass());
            filteredList.add((Map<String, String>)dataForThisObject.get(0));
        }
        if (statementData.size() > filteredList.size()) {
            statementData.retainAll(filteredList);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Data after subclass filtering");
            this.logData(statementData);
        }
    }

    private List<SubclassTemplateModel> collate(String subjectUri, ObjectProperty property, List<Map<String, String>> statementData, boolean editing) {
        String objectKey = this.getObjectKey();
        ArrayList<SubclassTemplateModel> subclasses = new ArrayList<SubclassTemplateModel>();
        for (Map<String, String> map : statementData) {
            String subclassUri = map.get(SUBCLASS_VARIABLE_NAME);
            VClass vclass = this.vclassDao.getVClassByURI(subclassUri);
            List<ObjectPropertyStatementTemplateModel> listForThisSubclass = null;
            for (SubclassTemplateModel subclass : subclasses) {
                VClass subclassVClass = subclass.getVClass();
                if ((vclass != null || subclassVClass != null) && (vclass == null || !vclass.equals(subclassVClass))) continue;
                listForThisSubclass = subclass.getStatements();
                break;
            }
            if (listForThisSubclass == null) {
                listForThisSubclass = new ArrayList<ObjectPropertyStatementTemplateModel>();
                subclasses.add(new SubclassTemplateModel(vclass, listForThisSubclass));
            }
            listForThisSubclass.add(new ObjectPropertyStatementTemplateModel(subjectUri, property, objectKey, map, this.getTemplateName(), this.vreq));
        }
        return subclasses;
    }

    public List<SubclassTemplateModel> getSubclasses() {
        return this.subclasses;
    }

    @Override
    public boolean isCollatedBySubclass() {
        return true;
    }

    private class DataComparatorBySubclass
    implements Comparator<Map<String, String>> {
        private DataComparatorBySubclass() {
        }

        @Override
        public int compare(Map<String, String> map1, Map<String, String> map2) {
            String subclass1 = map1.get(CollatedObjectPropertyTemplateModel.SUBCLASS_VARIABLE_NAME);
            String subclass2 = map2.get(CollatedObjectPropertyTemplateModel.SUBCLASS_VARIABLE_NAME);
            return subclass1.compareTo(subclass2);
        }
    }
}

