/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.searchresult;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vitro.webapp.web.ViewFinder;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualSearchResult
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(IndividualSearchResult.class);
    private static Class resultClass = IndividualSearchResult.class;
    protected final VitroRequest vreq;
    protected final Individual individual;

    public IndividualSearchResult(Individual individual, VitroRequest vreq) {
        this.vreq = vreq;
        this.individual = individual;
    }

    protected String getView(ViewFinder.ClassView view) {
        ViewFinder vf = new ViewFinder(view);
        return vf.findClassView(this.individual, this.vreq);
    }

    public static List<IndividualSearchResult> getIndividualTemplateModels(List<Individual> individuals, VitroRequest vreq) {
        ArrayList<IndividualSearchResult> models = new ArrayList<IndividualSearchResult>(individuals.size());
        for (Individual individual : individuals) {
            try {
                Constructor ctor = resultClass.getDeclaredConstructor(Individual.class, VitroRequest.class);
                models.add((IndividualSearchResult)ctor.newInstance(new Object[]{individual, vreq}));
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"Unable to create IndividualSearchResult", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)"Unable to create IndividualSearchResult", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Unable to create IndividualSearchResult", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"Unable to create IndividualSearchResult", (Throwable)e);
            }
        }
        return models;
    }

    public String getUri() {
        return this.individual.getURI();
    }

    public String getProfileUrl() {
        return UrlBuilder.getIndividualProfileUrl(this.individual, this.vreq);
    }

    public String getName() {
        return this.individual.getName();
    }

    public Collection<String> getMostSpecificTypes() {
        ObjectPropertyStatementDao opsDao = this.vreq.getWebappDaoFactory().getObjectPropertyStatementDao();
        Map<String, String> types = opsDao.getMostSpecificTypesInClassgroupsForIndividual(this.individual.getURI());
        return types.values();
    }

    public String getSnippet() {
        return this.individual.getSearchSnippet();
    }

    protected static void registerResultClass(Class clazz) {
        if (IndividualSearchResult.class.isAssignableFrom(clazz)) {
            resultClass = clazz;
        }
    }
}

