/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.linkeddatafragments.datasource.IDataSourceType;

public class ConfigReader {
    private final Map<String, IDataSourceType> dataSourceTypes = new HashMap<String, IDataSourceType>();
    private final Map<String, JsonObject> dataSources = new HashMap<String, JsonObject>();
    private final Map<String, String> prefixes = new HashMap<String, String>();
    private final String baseURL;

    public ConfigReader(Reader configReader) {
        JsonObject root = new JsonParser().parse(configReader).getAsJsonObject();
        this.baseURL = root.has("baseURL") ? root.getAsJsonPrimitive("baseURL").getAsString() : null;
        for (Map.Entry entry : root.getAsJsonObject("datasourcetypes").entrySet()) {
            String className = ((JsonElement)entry.getValue()).getAsString();
            this.dataSourceTypes.put((String)entry.getKey(), this.initDataSouceType(className));
        }
        for (Map.Entry entry : root.getAsJsonObject("datasources").entrySet()) {
            JsonObject dataSource = ((JsonElement)entry.getValue()).getAsJsonObject();
            this.dataSources.put((String)entry.getKey(), dataSource);
        }
        for (Map.Entry entry : root.getAsJsonObject("prefixes").entrySet()) {
            this.prefixes.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }

    public Map<String, IDataSourceType> getDataSourceTypes() {
        return this.dataSourceTypes;
    }

    public Map<String, JsonObject> getDataSources() {
        return this.dataSources;
    }

    public Map<String, String> getPrefixes() {
        return this.prefixes;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    protected IDataSourceType initDataSouceType(String className) {
        Object o;
        Class<?> c;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + className, e);
        }
        try {
            o = c.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Creating an instance of class '" + className + "' " + "caused a " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
        if (!(o instanceof IDataSourceType)) {
            throw new IllegalArgumentException("Class '" + className + "' is not an implementation " + "of IDataSourceType.");
        }
        return (IDataSourceType)o;
    }
}

